/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.quota;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.threading.ThreadPool;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.sync.cache.LocalCacheIndexer;
import ch.iterate.mountainduck.sync.quota.LocalCacheQuotaStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecursiveLocalCacheIndexer
implements LocalCacheIndexer {
    private static final Logger log = LogManager.getLogger((String)RecursiveLocalCacheIndexer.class.getName());
    private final LocalCacheIndexer proxy;

    public RecursiveLocalCacheIndexer(LocalCacheIndexer proxy) {
        this.proxy = proxy;
    }

    @Override
    public void index(Path directory, final LocalCacheQuotaStrategy strategy, ThreadPool.Priority priority) {
        this.proxy.index(directory, new LocalCacheQuotaStrategy(){

            @Override
            public void visit(Path file) {
                if (file.isDirectory()) {
                    if (!new FilesystemListFilter().accept(file)) {
                        log.warn(String.format("Skip indexing directory %s with duplicate flag", file));
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Recursively index directory %s", file));
                    }
                    RecursiveLocalCacheIndexer.this.index(file, strategy, ThreadPool.Priority.low);
                } else {
                    strategy.visit(file);
                }
            }

            @Override
            public AttributedList<Path> finish() {
                return strategy.finish();
            }
        }, ThreadPool.Priority.low);
    }

    @Override
    public void purge(Path file) {
        this.proxy.purge(file);
    }

    @Override
    public void flush() {
        this.proxy.flush();
    }

    @Override
    public void shutdown() {
        this.proxy.shutdown();
    }
}

