/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.quota;

import java.util.Comparator;
import java.util.TreeSet;

class LimitedTreeSet<E>
extends TreeSet<E> {
    private final long limit;
    private final Comparator<E> comparator;

    public LimitedTreeSet(long limit, Comparator<E> comparator) {
        super(comparator);
        this.limit = limit;
        this.comparator = comparator;
    }

    @Override
    public boolean add(E p) {
        int current = this.size();
        if (current > 0 && (long)current >= this.limit) {
            Object lowest = this.last();
            if (this.comparator.compare(p, lowest) < 0) {
                this.remove(lowest);
            } else {
                return false;
            }
        }
        return super.add(p);
    }
}

