/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.quota;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.quota.LimitedTreeSet;
import ch.iterate.mountainduck.sync.quota.LocalCacheQuotaStrategy;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LastAccessLocalCacheQuotaStrategy
implements LocalCacheQuotaStrategy {
    private static final Logger log = LogManager.getLogger((String)LastAccessLocalCacheQuotaStrategy.class.getName());
    private final Collection<Path> candidates;
    private final long retention;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;

    public LastAccessLocalCacheQuotaStrategy(LocalCache<?> cache, MetadataService<?> metadata) {
        this(PreferencesFactory.get().getLong("fs.sync.cache.indexer.strategy.chunksize"), PreferencesFactory.get().getLong("fs.sync.cache.indexer.strategy.lru.retention.days"), cache, metadata);
    }

    public LastAccessLocalCacheQuotaStrategy(long chunkSize, long retention, LocalCache<?> cache, MetadataService<?> metadata) {
        this.retention = retention;
        this.cache = cache;
        this.metadata = metadata;
        this.candidates = Collections.synchronizedCollection(new LimitedTreeSet<Path>(chunkSize, new LastAccessComparator(cache, metadata)));
    }

    @Override
    public void visit(Path file) {
        long threshold;
        long lastaccess = MetadataStorage.Key.lastaccess.fromDictionary(this.metadata.read(this.cache.toLocal(file), MetadataStorage.Key.lastaccess));
        if (lastaccess < (threshold = LocalDateTime.now().minusDays(this.retention).toInstant(ZoneOffset.UTC).toEpochMilli())) {
            this.candidates.add(file);
        }
    }

    @Override
    public AttributedList<Path> finish() {
        AttributedList result = new AttributedList();
        result.addAll(this.candidates);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Collected %d files to purge", result.size()));
        }
        return result;
    }

    private static final class LastAccessComparator
    implements Comparator<Path> {
        private final LocalCache<?> cache;
        private final MetadataService<?> metadata;

        public LastAccessComparator(LocalCache<?> cache, MetadataService<?> metadata) {
            this.cache = cache;
            this.metadata = metadata;
        }

        @Override
        public int compare(Path p1, Path p2) {
            return Long.compare(MetadataStorage.Key.lastaccess.fromDictionary(this.metadata.read(this.cache.toLocal(p1), MetadataStorage.Key.lastaccess)), MetadataStorage.Key.lastaccess.fromDictionary(this.metadata.read(this.cache.toLocal(p2), MetadataStorage.Key.lastaccess)));
        }
    }
}

