/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.quota;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.sync.quota.LocalCacheQuotaStrategy;
import java.util.Arrays;

public class ChainedLocalCacheQuotaStrategy
implements LocalCacheQuotaStrategy {
    private final LocalCacheQuotaStrategy[] chain;

    public ChainedLocalCacheQuotaStrategy(LocalCacheQuotaStrategy ... strategies) {
        this.chain = strategies;
    }

    @Override
    public void visit(Path file) {
        for (LocalCacheQuotaStrategy strategy : this.chain) {
            strategy.visit(file);
        }
    }

    @Override
    public AttributedList<Path> finish() {
        AttributedList result = new AttributedList();
        for (LocalCacheQuotaStrategy strategy : this.chain) {
            result.addAll(strategy.finish());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChainedLocalCacheQuotaStrategy{");
        sb.append("chain=").append(Arrays.toString(this.chain));
        sb.append('}');
        return sb.toString();
    }
}

