/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.quota;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.ThreadPool;
import ch.iterate.mountainduck.fs.FilesystemIncrementalListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.cache.LocalCacheIndexer;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.option.SelectiveSyncOption;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.sync.quota.LocalCacheQuotaStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockingLocalCacheQuotaIndexer
implements LocalCacheIndexer {
    private static final Logger log = LogManager.getLogger((String)BlockingLocalCacheQuotaIndexer.class.getName());
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final SyncQueue queue;
    private final NotificationService notifications = NotificationServiceFactory.get();

    public BlockingLocalCacheQuotaIndexer(Host bookmark, LocalCache<?> cache, MetadataService<?> metadata, SyncQueue queue) {
        this.bookmark = bookmark;
        this.cache = cache;
        this.metadata = metadata;
        this.queue = queue;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void index(Path directory, LocalCacheQuotaStrategy strategy, ThreadPool.Priority priority) {
        if (log.isInfoEnabled()) {
            log.debug(String.format("Index directory %s with callback %s", directory, strategy));
        }
        SelectiveSyncOption sync = new SelectiveSyncOption(this.cache, this.metadata);
        FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(new Host((Protocol)new LocalProtocol()));
        try {
            Path next;
            this.cache.list(directory, (FilesystemListProgressListener)listener, 0L);
            while ((next = listener.next()) != null) {
                if (sync.include(next)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug(String.format("Skip %s as marked to keep offline", next));
                    continue;
                }
                if (next.isSymbolicLink()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug(String.format("Skip symlink %s", next));
                    continue;
                }
                strategy.visit(next);
            }
        }
        catch (BackgroundException e) {
            log.error(String.format("Failure %s listing directory %s", new Object[]{e, this.cache.toLocal(directory)}));
        }
    }

    @Override
    public void purge(Path file) {
        this.queue.beginQueueing(file, this.cache.toLocal(file));
        try {
            this._purge(file, this.cache.toLocal(file));
        }
        finally {
            this.queue.endQueueing(file, this.cache.toLocal(file));
        }
    }

    @Override
    public void flush() {
    }

    private void _purge(Path file, Local local) {
        if (local.exists() && file.isFile()) {
            try {
                if (PreferencesFactory.get().getBoolean("fs.sync.notification.purge")) {
                    this.notifications.notify(BookmarkNameProvider.toString((Host)this.bookmark), this.cache.toMount(file).getAbsolute(), LocaleFactory.localizedString((String)"File Uncached", (String)"Disk"), file.getName(), LocaleFactory.localizedString((String)"Show", (String)"Localizable"));
                }
                log.warn(String.format("Truncate file %s in cache", local));
                this.queue.purge(local, file);
            }
            catch (BackgroundException e) {
                log.error(String.format("Failure %s removing file %s from cache", new Object[]{e, local}));
            }
        }
    }
}

