/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.filter;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.date.AbstractUserDateFormatter;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConflictException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.DisabledUploadSymlinkResolver;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.RenameExistingFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.conflict.MetadataConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import java.nio.file.LinkOption;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.TimeZone;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncQueueWriteFilter
extends RenameExistingFilter {
    private static final Logger log = LogManager.getLogger((String)SyncQueueWriteFilter.class.getName());
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final QueueLock<?> lock;
    private final MetadataService<?> metadata;
    private final Session<?> session;
    private final ReloadService reload;
    private final Preferences preferences = PreferencesFactory.get();

    public SyncQueueWriteFilter(Host bookmark, LocalCache<?> cache, QueueLock<?> lock, MetadataService<?> metadata, ReloadService reload, Session<?> session, UploadFilterOptions options) {
        super((SymlinkResolver)new DisabledUploadSymlinkResolver(), session, options);
        this.bookmark = bookmark;
        this.cache = cache;
        this.lock = lock;
        this.metadata = metadata;
        this.reload = reload;
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        this.lock.acquire(file, QueueLock.Option.branch);
        try {
            if (!local.exists(new LinkOption[0])) {
                throw new LocalAccessDeniedException(local.getAbsolute());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.release(file);
        }
    }

    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        TransferStatus status = super.prepare(file, local, parent, progress).withRegion(file.attributes().getRegion());
        if (file.isFile()) {
            status.setLength(this.cache.getattr(local).getSize());
            if (status.getRemote().isDuplicate()) {
                log.warn(String.format("Existing file %s marked as duplicate", file));
                status.setExists(false);
            }
        }
        if (this.options.timestamp) {
            if (this.metadata.read(local, MetadataStorage.Key.modificationdate) != null) {
                status.setTimestamp(Long.valueOf(this.cache.getattr(file).getModificationDate()));
            } else {
                status.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            }
        }
        status.setLockId((Object)this.cache.getLock(file));
        return status;
    }

    public void apply(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        if (file.isFile() && status.isExists()) {
            switch (new MetadataConflictResolutionStrategy(this.cache, this.metadata).resolve(local, status.getRemote())) {
                case unknown: {
                    log.warn(String.format("Skip conflict resolution for %s", file));
                }
                case equal: {
                    break;
                }
                default: {
                    Move move;
                    String proposal;
                    Path rename;
                    if (TransferAction.cancel.equals((Object)TransferAction.forName((String)this.preferences.getProperty("fs.sync.queue.conflict.action")))) {
                        throw new ConflictException(String.format("Sync conflict for file %s", local));
                    }
                    log.warn(String.format("Sync conflict for file %s", file));
                    if (this.preferences.getBoolean("fs.sync.notification.conflict")) {
                        NotificationServiceFactory.get().notify(BookmarkNameProvider.toString((Host)this.bookmark), this.cache.toMount(file).getAbsolute(), LocaleFactory.localizedString((String)"Sync Conflict", (String)"Disk"), file.getName(), LocaleFactory.localizedString((String)"Show", (String)"Localizable"));
                    }
                    do {
                        TimeZone timezone;
                        AbstractUserDateFormatter formatter = (timezone = this.session.getHost().getTimezone()) == null ? UserDateFormatterFactory.get() : UserDateFormatterFactory.get((String)timezone.getID());
                        proposal = MessageFormat.format(this.preferences.getProperty("queue.upload.file.rename.format"), FilenameUtils.removeExtension((String)PathNormalizer.name((String)file.getName())), formatter.getMediumFormat(System.currentTimeMillis(), false).replace('/', '-').replace(':', '-'), StringUtils.isNotBlank((CharSequence)file.getExtension()) ? String.format(".%s", file.getExtension()) : "");
                    } while (this.find.find(rename = new Path(file.getParent(), proposal, file.getType())));
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Rename existing file %s to %s", file, rename));
                    }
                    if ((move = (Move)this.session.getFeature(Move.class)).isSupported(file, rename)) {
                        Path target = move.move(file, rename, new TransferStatus().exists(false), (Delete.Callback)new Delete.DisabledCallback(), (ConnectionCallback)new DisabledConnectionCallback());
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Clear exist flag for file %s", file));
                        }
                        status.setExists(false);
                        PathAttributes attributes = status.getRemote();
                        this.cache.placeholder(target, attributes);
                        break;
                    }
                    log.warn(String.format("Rename not supported for file %s", file));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        block14: {
            block13: {
                PathAttributes attr;
                block12: {
                    super.complete(file, local, status, listener);
                    if (!status.isComplete()) break block13;
                    this.lock.acquire(file, QueueLock.Option.branch);
                    if (file.isFile()) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Retrieve remote attributes %s from write response", status.getResponse()));
                        }
                        attr = status.getResponse();
                    } else {
                        attr = file.attributes();
                    }
                    if (PathAttributes.EMPTY.equals((Object)attr)) {
                        if (log.isWarnEnabled()) {
                            log.warn(String.format("Retrieve missing remote attributes for file %s uploaded", file));
                        }
                        try {
                            attr = ((AttributesFinder)this.session.getFeature(AttributesFinder.class)).find(file.withAttributes(new PathAttributes(file.attributes()).withVersionId(null)));
                        }
                        catch (NotfoundException e) {
                            log.warn(String.format("Failure %s finding file %s after upload", new Object[]{e, file}));
                            this.cache.setattr(file, file.getType(), this.toAttributes(file, status), true);
                            if (this.preferences.getBoolean("queue.upload.complete.notfound.ignore")) {
                                this.reload.reload(file, this.cache.toMount(file), Collections.singletonMap(file, ReloadService.Change.deleted));
                                this.lock.release(file);
                                return;
                            }
                            throw e;
                        }
                    }
                    if (!log.isDebugEnabled()) break block12;
                    log.debug(String.format("Set metadata %s for %s after write operation", attr, file));
                }
                this.cache.setattr(file, file.getType(), attr, false);
                break block14;
                finally {
                    this.lock.release(file);
                }
            }
            log.warn(String.format("Skip updating metadata for %s for incomplete upload", file));
        }
    }

    private PathAttributes toAttributes(Path file, TransferStatus status) {
        PathAttributes attr = new PathAttributes(file.attributes());
        attr.setSize(status.getLength());
        if (null == this.session.getFeature(Timestamp.class)) {
            log.warn(String.format("Skip setting timestamp in metadata for %s", file));
        } else if (null != status.getTimestamp()) {
            attr.setModificationDate(status.getTimestamp().longValue());
        }
        return attr;
    }
}

