/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.filter;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.TransferStatusCanceledException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.conflict.ChecksumConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SyncOperationCanceledException;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueWriteFilter;
import ch.iterate.mountainduck.sync.status.DeleteInProgressStatusService;
import ch.iterate.mountainduck.sync.status.WriteInProgressStatusService;
import com.dd.plist.NSDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncQueueUploadFilter
extends SyncQueueWriteFilter {
    private static final Logger log = LogManager.getLogger((String)SyncQueueUploadFilter.class.getName());
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final FileHistory history;
    private final Application application;
    private final Preferences preferences = PreferencesFactory.get();

    public SyncQueueUploadFilter(Host bookmark, LocalCache<?> cache, QueueLock<?> lock, MetadataService<?> metadata, FileHistory history, ReloadService reload, Session<?> session, UploadFilterOptions options, Application application) {
        super(bookmark, cache, lock, metadata, reload, session, options);
        this.bookmark = bookmark;
        this.cache = cache;
        this.metadata = metadata;
        this.history = history;
        this.application = application;
    }

    @Override
    public TransferStatus prepare(final Path file, final Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        TransferStatus status = super.prepare(file, local, parent, progress);
        if (file.isFile()) {
            ChecksumTransferStatus checksum = new ChecksumTransferStatus(ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.valueOf((String)this.preferences.getProperty("fs.sync.queue.checksum"))).compute(local.getInputStream(), new TransferStatus()), status){

                public void validate() throws TransferStatusCanceledException {
                    super.validate();
                    if (!this.isComplete()) {
                        switch (new DeleteInProgressStatusService(SyncQueueUploadFilter.this.cache, SyncQueueUploadFilter.this.metadata).getStatus(local).getState()) {
                            case inprogress: {
                                log.warn(String.format("Cancel upload for file %s with delete in progress", file));
                                throw new SyncOperationCanceledException(String.format("Cancel upload for file %s with delete in progress", file.getName()));
                            }
                        }
                        if (!Checksum.NONE.equals((Object)this.checksum)) {
                            FileStatusService.Status progress = new WriteInProgressStatusService(SyncQueueUploadFilter.this.cache, SyncQueueUploadFilter.this.metadata).getStatus(local);
                            switch (progress.getState()) {
                                case inprogress: {
                                    NSDictionary dict = progress.getDictionary();
                                    if (null == dict || !dict.containsKey("Checksum")) break;
                                    Checksum latest = new Checksum(HashAlgorithm.valueOf((String)SyncQueueUploadFilter.this.preferences.getProperty("fs.sync.queue.checksum")), dict.get((Object)"Checksum").toString());
                                    if (!latest.algorithm.equals((Object)this.checksum.algorithm) || latest.equals((Object)this.checksum)) break;
                                    if (log.isWarnEnabled()) {
                                        log.warn(String.format("Cancel upload for file %s with checksum mismatch", file));
                                    }
                                    if (!this.isExists()) break;
                                    throw new SyncOperationCanceledException(String.format("Cancel upload for file %s with checksum mismatch", file.getName()));
                                }
                            }
                        }
                    }
                }
            };
            checksum.validate();
            return checksum;
        }
        switch (new ChecksumConflictResolutionStrategy(this.metadata).resolve(local, status.getRemote())) {
            case equal: {
                throw new SyncOperationCanceledException(String.format("Cancel upload for file %s with equal checksum", file.getName()));
            }
        }
        return status;
    }

    @Override
    public void complete(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        super.complete(file, local, status, listener);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Delete write in progress for file %s", file));
        }
        this.metadata.delete(local, MetadataStorage.Key.write);
        if (status.isComplete()) {
            this.history.add(new FileHistory.Item(file, this.cache.toMount(file), FileHistory.Item.Origin.local, Operation.write, this.application));
            if (this.preferences.getBoolean("fs.sync.notification.upload")) {
                NotificationServiceFactory.get().notify(BookmarkNameProvider.toString((Host)this.bookmark), this.cache.toMount(file).getAbsolute(), LocaleFactory.localizedString((String)"Upload complete", (String)"Status"), file.getName(), LocaleFactory.localizedString((String)"Show", (String)"Localizable"));
            }
        }
    }

    private static class ChecksumTransferStatus
    extends TransferStatus {
        public final Checksum checksum;

        public ChecksumTransferStatus(Checksum checksum, TransferStatus copy) {
            super(copy);
            this.checksum = checksum;
        }
    }
}

