/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.filter;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueWriteFilter;

public class SyncQueueRenameFilter
extends SyncQueueWriteFilter {
    private final Preferences preferences = PreferencesFactory.get();
    private final LocalCache<?> cache;
    private final FileHistory history;

    public SyncQueueRenameFilter(Host bookmark, LocalCache<?> cache, QueueLock<?> lock, MetadataService<?> metadata, FileHistory history, ReloadService reload, Session<?> session, UploadFilterOptions options) {
        super(bookmark, cache, lock, metadata, reload, session, options);
        this.cache = cache;
        this.history = history;
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) {
        return true;
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        if (this.preferences.getBoolean("fs.sync.rename.conflict.detect")) {
            return super.prepare(file, local, parent, progress);
        }
        TransferStatus status = new TransferStatus();
        status.setLockId((Object)this.cache.getLock(file));
        return status;
    }

    @Override
    public void complete(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        super.complete(file, local, status.withResponse(file.attributes()), listener);
        this.history.add(new FileHistory.Item(file, this.cache.toMount(file), FileHistory.Item.Origin.local, Operation.rename));
    }
}

