/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.filter;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.status.CacheExpiryStatusService;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SyncQueueFindService
implements Find {
    private static final Logger log = LogManager.getLogger((String)SyncQueueFindService.class.getName());
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final Find finder;

    public SyncQueueFindService(Host bookmark, LocalCache<?> cache, MetadataService<?> metadata, Find finder) {
        this.bookmark = bookmark;
        this.cache = cache;
        this.metadata = metadata;
        this.finder = finder;
    }

    public boolean find(Path file, ListProgressListener listener) throws BackgroundException {
        switch (new CacheExpiryStatusService(MetadataStorage.Key.timestamp, this.cache, this.metadata).withExpiry(PreferencesFactory.get().getLong("queue.upload.index.expire.ms")).getStatus(file.getParent()).getState()) {
            case unknown: 
            case remote: {
                return this.finder.find(file.withAttributes(new PathAttributes(file.attributes()).withVersionId(null)));
            }
        }
        log.warn(String.format("Skip reading remote attributes for file %s", file));
        switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(file).getState()) {
            case unknown: 
            case local: {
                return false;
            }
        }
        return true;
    }
}

