/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.filter;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.TransferStatusCanceledException;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.download.OverwriteFilter;
import ch.cyberduck.core.transfer.symlink.DisabledDownloadSymlinkResolver;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.conflict.MetadataConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SyncOperationCanceledException;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueAttributesFinder;
import ch.iterate.mountainduck.sync.status.DeleteInProgressStatusService;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import ch.iterate.mountainduck.sync.status.RenameInProgressStatusService;
import ch.iterate.mountainduck.sync.status.WriteInProgressStatusService;
import com.dd.plist.NSDictionary;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncQueueDownloadFilter
extends OverwriteFilter {
    private static final Logger log = LogManager.getLogger((String)SyncQueueDownloadFilter.class.getName());
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final FileHistory history;
    private final ReloadService reload;
    private final Session<?> session;
    private final Preferences preferences = PreferencesFactory.get();
    private final NotificationService notificationService = NotificationServiceFactory.get();

    public SyncQueueDownloadFilter(Host bookmark, LocalCache<?> cache, QueueLock<?> lock, MetadataService<?> metadata, FileHistory history, ReloadService reload, Session<?> session, DownloadFilterOptions options) {
        super((SymlinkResolver)new DisabledDownloadSymlinkResolver(), session, options);
        this.bookmark = bookmark;
        this.cache = cache;
        this.metadata = metadata;
        this.reload = reload;
        this.history = history;
        this.session = session;
        this.withAttributes(new SyncQueueAttributesFinder(bookmark, cache, metadata, this.attribute));
    }

    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (!this.cache.getDirectory().exists()) {
            throw new NotfoundException(this.cache.getDirectory().getAbsolute());
        }
        return true;
    }

    public TransferStatus prepare(final Path file, final Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        Local temporary = LocalFactory.get((String)TemporaryFileServiceFactory.get().create(file).getAbsolute());
        if (log.isDebugEnabled()) {
            log.debug(String.format("Download %s to temporary location in %s", file, temporary));
        }
        TransferStatus status = new TransferStatus(super.prepare(file, temporary, parent, progress)){

            public void validate() throws TransferStatusCanceledException {
                super.validate();
                if (!this.isComplete()) {
                    switch (new WriteInProgressStatusService(SyncQueueDownloadFilter.this.cache, SyncQueueDownloadFilter.this.metadata).getStatus(file).getState()) {
                        case inprogress: {
                            log.warn(String.format("Skip read of file %s with pending write operation in queue", file));
                            throw new SyncOperationCanceledException(String.format("Skip read of file %s with pending write operation in queue", file.getName()));
                        }
                    }
                    switch (new DeleteInProgressStatusService(SyncQueueDownloadFilter.this.cache, SyncQueueDownloadFilter.this.metadata).getStatus(local).getState()) {
                        case inprogress: {
                            log.warn(String.format("Skip read of file %s pending delete in queue", file));
                            throw new SyncOperationCanceledException(String.format("Skip read of file %s pending delete in queue", file.getName()));
                        }
                    }
                    switch (new RenameInProgressStatusService(SyncQueueDownloadFilter.this.cache, SyncQueueDownloadFilter.this.metadata).getStatus(local).getState()) {
                        case inprogress: {
                            log.warn(String.format("Skip read of file %s pending rename in queue", file));
                            throw new SyncOperationCanceledException(String.format("Skip read of file %s pending rename in queue", file.getName()));
                        }
                    }
                }
            }
        };
        status.validate();
        if (status.isExists()) {
            switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(file).getState()) {
                case synced: {
                    switch (new MetadataConflictResolutionStrategy(this.cache, this.metadata).resolve(local, status.getRemote())) {
                        case equal: {
                            throw new SyncOperationCanceledException(String.format("Skip file %s already in sync with remote attributes %s", file, status.getRemote()));
                        }
                    }
                }
            }
        }
        return status.withRename(temporary).withDisplayname(local);
    }

    public void complete(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        if (status.isSegment()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Skip completion for single segment %s", status));
            }
            return;
        }
        Local destination = status.getDisplayname().local;
        super.complete(file, local, status.withDisplayname((Local)null), listener);
        if (status.isComplete()) {
            this.cache.close(file, FilesystemCallbacks.Mode.read, Application.notfound);
            this.cache.close(file, FilesystemCallbacks.Mode.write, Application.notfound);
            for (MetadataStorage.Key key : MetadataStorage.Key.values()) {
                NSDictionary dict = this.metadata.read(destination, key);
                if (null == dict) continue;
                this.metadata.write(local, key, dict);
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("Move file %s to %s in cache", file, destination));
            }
            this.metadata.flush(local);
            local.rename(destination);
            if (null == this.metadata.read(local, MetadataStorage.Key.placeholder)) {
                this.history.add(new FileHistory.Item(file, this.cache.toMount(file), FileHistory.Item.Origin.remote, Operation.read));
                if (this.preferences.getBoolean("fs.sync.notification.download")) {
                    this.notificationService.notify(BookmarkNameProvider.toString((Host)this.bookmark), this.cache.toMount(file).getAbsolute(), LocaleFactory.localizedString((String)"File Updated", (String)"Disk"), file.getName(), LocaleFactory.localizedString((String)"Show", (String)"Localizable"));
                }
            }
            PathAttributes attributes = status.getRemote();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Update metadata for %s after download", file));
            }
            this.cache.setattr(file, file.getType(), attributes, true);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Remove placeholder flag for file %s", file));
            }
            this.metadata.delete(local, MetadataStorage.Key.placeholder);
        }
        this.reload.reload(file, this.cache.toMount(file), Collections.singletonMap(file, ReloadService.Change.changed));
    }
}

