/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.filter;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.conflict.MetadataConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SyncOperationCanceledException;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueWriteFilter;
import ch.iterate.mountainduck.sync.status.ErrorStatusService;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncQueueDeleteFilter
extends SyncQueueWriteFilter {
    private static final Logger log = LogManager.getLogger((String)SyncQueueDeleteFilter.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final FileHistory history;
    private final ReloadService reload;

    public SyncQueueDeleteFilter(Host bookmark, LocalCache<?> cache, QueueLock<?> lock, MetadataService<?> metadata, FileHistory history, ReloadService reload, Session<?> session, UploadFilterOptions options) {
        super(bookmark, cache, lock, metadata, reload, session, options);
        this.bookmark = bookmark;
        this.cache = cache;
        this.metadata = metadata;
        this.history = history;
        this.reload = reload;
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) {
        return true;
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        if (this.preferences.getBoolean("fs.sync.delete.conflict.detect")) {
            return super.prepare(file, local, parent, progress);
        }
        TransferStatus status = new TransferStatus();
        status.setLockId((Object)this.cache.getLock(file));
        return status;
    }

    @Override
    public void apply(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        if (file.isFile() && status.isExists()) {
            block0 : switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(file).getState()) {
                case local: {
                    log.warn(String.format("Missing metadata for file %s", file));
                    break;
                }
                default: {
                    switch (new MetadataConflictResolutionStrategy(this.cache, this.metadata).resolve(local, status.getRemote())) {
                        case unknown: {
                            log.warn(String.format("Skip conflict resolution for %s", file));
                        }
                        case equal: {
                            break block0;
                        }
                    }
                    switch (new ErrorStatusService(this.cache, this.metadata).getStatus(file).getState()) {
                        default: {
                            if (!this.preferences.getBoolean("fs.sync.delete.conflict.fail.default")) break block0;
                        }
                        case error: {
                            if (!this.preferences.getBoolean("fs.sync.delete.conflict.fail.error")) break block0;
                            if (this.preferences.getBoolean("fs.sync.notification.conflict")) {
                                NotificationServiceFactory.get().notify(BookmarkNameProvider.toString((Host)this.bookmark), this.cache.toMount(file.getParent()).getAbsolute(), LocaleFactory.localizedString((String)"Sync Conflict", (String)"Disk"), file.getName(), LocaleFactory.localizedString((String)"Show", (String)"Localizable"));
                            }
                            log.warn(String.format("Skip delete of file %s with sync conflict. Create new placeholder in cache with attributes %s", file, status.getRemote()));
                            this.cache.placeholder(file, status.getRemote());
                            this.reload.reload(file.getParent(), this.cache.toMount(file.getParent()), Collections.singletonMap(file, ReloadService.Change.added));
                            throw new SyncOperationCanceledException(String.format("Skip delete of file %s with sync conflict", file.getName()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void complete(Path file, Local local, TransferStatus status, ProgressListener listener) {
        this.history.add(new FileHistory.Item(file, this.cache.toMount(file), FileHistory.Item.Origin.local, Operation.delete));
    }
}

