/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConflictException;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.QueueErrorCallback;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncQueueTransferErrorCallback
implements TransferErrorCallback {
    private static final Logger log = LogManager.getLogger((String)SyncQueueTransferErrorCallback.class.getName());
    private final Operation operation;
    private final QueueErrorCallback error;

    public SyncQueueTransferErrorCallback(Operation operation, QueueErrorCallback error) {
        this.operation = operation;
        this.error = error;
    }

    public boolean prompt(TransferItem item, TransferStatus status, BackgroundException failure, int pending) {
        log.warn(String.format("Transfer failure %s for %s with status %s", new Object[]{failure, item, status}));
        if (item.remote.isDirectory() && failure instanceof ConflictException) {
            log.warn(String.format("Ignore failure %s creating directory %s", new Object[]{failure, item.remote}));
            return true;
        }
        this.error.operationFailed(new SerializableOperation(this.operation, item.local, item.remote).withLength(status.getLength()), failure);
        switch (new DefaultFailureDiagnostics().determine(failure)) {
            case cancel: {
                log.warn(String.format("Interrupt operation %s", this.operation));
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Continue transfer with %d files pending", pending));
        }
        return true;
    }
}

