/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncQueueFactory
extends Factory<SyncQueue> {
    private static final Logger log = LogManager.getLogger((String)SyncQueueFactory.class.getName());

    protected SyncQueueFactory() {
        super("factory.sync.queue.class");
    }

    public static SyncQueue get(Controller controller, SessionPool fs, LocalCache<?> cache, QueueLock<Boolean> lock, MetadataService<?> metadata, FileHistory history, ReloadService reload) {
        return new SyncQueueFactory().create(controller, fs, cache, lock, metadata, history, reload);
    }

    private SyncQueue create(Controller controller, SessionPool fs, LocalCache<?> cache, QueueLock<Boolean> lock, MetadataService<?> metadata, FileHistory history, ReloadService reload) {
        String clazz = PreferencesFactory.get().getProperty("factory.sync.queue.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", ((Object)((Object)this)).getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{controller.getClass(), fs.getClass(), cache.getClass(), lock.getClass(), metadata.getClass(), history.getClass(), reload.getClass()});
            return (SyncQueue)constructor.newInstance(controller, fs, cache, lock, metadata, history, reload);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException var6) {
            log.error(String.format("Failure loading callback class %s. %s", clazz, var6.getMessage()));
            throw new FactoryException();
        }
    }
}

