/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.CacheSetattrCallback;
import ch.iterate.mountainduck.sync.queue.Operation;
import com.dd.plist.NSDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultSetattrCallback
implements CacheSetattrCallback {
    private static final Logger log = LogManager.getLogger((String)DefaultSetattrCallback.class.getName());
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final FileHistory history;

    public DefaultSetattrCallback(Host bookmark, LocalCache<?> cache, MetadataService<?> metadata, FileHistory history) {
        this.bookmark = bookmark;
        this.cache = cache;
        this.metadata = metadata;
        this.history = history;
    }

    @Override
    public boolean setattr(Path file, PathAttributes attr, Local local, boolean prune) {
        NSDictionary meta = this.metadata.read(local, MetadataStorage.Key.metadata);
        if (null == meta) {
            log.error(String.format("Missing metadata of %s in extended attributes for %s", file, local));
            this.cache.setattr(file, file.getType(), attr, true);
            return true;
        }
        if (!new PathAttributesDictionary().deserialize((Object)meta).equals((Object)attr)) {
            if (file.isFile()) {
                this.history.add(new FileHistory.Item(file, this.cache.toMount(file), FileHistory.Item.Origin.remote, Operation.write));
                if (PreferencesFactory.get().getBoolean("fs.sync.notification.metadata")) {
                    NotificationServiceFactory.get().notify(BookmarkNameProvider.toString((Host)this.bookmark), this.cache.toMount(file).getAbsolute(), LocaleFactory.localizedString((String)"File Updated", (String)"Disk"), file.getName(), LocaleFactory.localizedString((String)"Show", (String)"Localizable"));
                }
            }
            this.cache.setattr(file, file.getType(), attr, prune);
            return true;
        }
        log.warn(String.format("Skip updating metadata for %s", file));
        return false;
    }
}

