/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.queue.QueueReadCallback;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.sync.status.DeleteInProgressStatusService;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import ch.iterate.mountainduck.sync.status.RenameInProgressStatusService;
import ch.iterate.mountainduck.sync.status.WriteInProgressStatusService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultQueueReadCallback
implements QueueReadCallback {
    private static final Logger log = LogManager.getLogger((String)DefaultQueueReadCallback.class.getName());
    private final SyncQueue queue;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;

    public DefaultQueueReadCallback(SyncQueue queue, LocalCache<?> cache, MetadataService<?> metadata) {
        this.queue = queue;
        this.cache = cache;
        this.metadata = metadata;
    }

    public boolean read(Local local, Path file) throws BackgroundException {
        switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case ignored: 
            case local: {
                log.warn(String.format("Skip reading file %s in cache with local only state", local));
                return false;
            }
        }
        switch (new WriteInProgressStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case inprogress: {
                log.warn(String.format("Skip read of file %s with pending write operation in queue", file));
                return false;
            }
        }
        switch (new DeleteInProgressStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case inprogress: {
                log.warn(String.format("Skip read of file %s pending delete in queue", file));
                return false;
            }
        }
        switch (new RenameInProgressStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case inprogress: {
                log.warn(String.format("Skip read of file %s pending rename in queue", file));
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Update file %s in cache with latest version from remote", local));
        }
        this.queue.read(local, file);
        return true;
    }
}

