/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.ThreadPool;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.indexer.DirectoryIndexerVisitorCallback;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.conflict.DirectoryConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.QueueIndexCallback;
import ch.iterate.mountainduck.sync.status.CacheExpiryStatusService;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import ch.iterate.mountainduck.sync.status.ReachabilityStatusService;
import com.dd.plist.NSDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultIndexerIndexCallback
implements QueueIndexCallback,
DirectoryIndexerVisitorCallback {
    private static final Logger log = LogManager.getLogger((String)DefaultIndexerIndexCallback.class.getName());
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final MetadataService<NSDictionary> metadata;
    private final DirectoryIndexer indexer;
    private final ReachabilityStatusService reachability;
    private final FileStatusService status;
    private final ReloadService reload;

    public DefaultIndexerIndexCallback(Host bookmark, LocalCache<?> cache, MetadataService<NSDictionary> metadata, DirectoryIndexer indexer, ReachabilityStatusService reachability, FileStatusService status, ReloadService reload) {
        this.bookmark = bookmark;
        this.cache = cache;
        this.metadata = metadata;
        this.indexer = indexer;
        this.reachability = reachability;
        this.status = status;
        this.reload = reload;
    }

    public void index(Local local, Path directory) {
        switch (this.status.getStatus(directory).getState()) {
            case inprogress: {
                log.warn(String.format("Skip index update for %s with in progress state", directory));
                return;
            }
        }
        if (FilesystemFilenameBlacklist.temporary.contains(directory)) {
            return;
        }
        block4 : switch (new CacheExpiryStatusService(MetadataStorage.Key.indexed, this.cache, this.metadata).withExpiry(PreferencesFactory.get().getLong("fs.sync.list.index.expire.ms")).getStatus(directory).getState()) {
            case unknown: 
            case remote: {
                switch (this.reachability.getStatus(directory).getState()) {
                    case unknown: {
                        try {
                            this.indexer.index(directory, (DirectoryIndexerVisitorCallback)this, ThreadPool.Priority.max, this.reload);
                        }
                        catch (BackgroundException e) {
                            log.warn(String.format("Unhandled failure %s", new Object[]{e}));
                        }
                        break block4;
                    }
                }
                if (!log.isDebugEnabled()) break;
                log.debug(String.format("Unreachable. Skip index update for %s", directory));
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug(String.format("Not expired. Skip index update for %s", directory));
            }
        }
    }

    public void visit(Path file) {
        if (file.isDirectory()) {
            switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(file).getState()) {
                case synced: {
                    switch (new DirectoryConflictResolutionStrategy(this.bookmark, this.metadata).resolve(this.cache.toLocal(file), file.attributes())) {
                        case local: 
                        case equal: {
                            log.warn(String.format("Skip indexing directory %s with attributes %s", file, file.attributes()));
                            return;
                        }
                    }
                }
            }
            if (new FilesystemListFilter().accept(file)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Recursively index directory %s", file));
                }
                try {
                    this.indexer.index(file, DirectoryIndexer.NO_CALLBACK, ThreadPool.Priority.norm, this.reload);
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Unhandled failure %s", new Object[]{e}));
                }
            }
        }
    }

    public void finish(Path directory) {
    }
}

