/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.queue.CachePlaceholderCallback;
import ch.iterate.mountainduck.sync.status.DeleteInProgressStatusService;
import ch.iterate.mountainduck.sync.status.RenameInProgressStatusService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultCachePlaceholderCallback
implements CachePlaceholderCallback {
    private static final Logger log = LogManager.getLogger((String)DefaultCachePlaceholderCallback.class.getName());
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;

    public DefaultCachePlaceholderCallback(LocalCache<?> cache, MetadataService<?> metadata) {
        this.cache = cache;
        this.metadata = metadata;
    }

    @Override
    public boolean placeholder(Local local, Path file) throws BackgroundException {
        switch (new DeleteInProgressStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case inprogress: {
                log.warn(String.format("Skip adding placeholder for file %s pending delete in queue", file));
                return false;
            }
        }
        switch (new RenameInProgressStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case inprogress: {
                log.warn(String.format("Skip adding placeholder for file %s pending rename in queue", file));
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create placeholder for file %s in %s", file, local));
        }
        this.cache.placeholder(file, file.attributes());
        return true;
    }
}

