/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.CacheDeleteCallback;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.SerializableOperationException;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.sync.status.ErrorStatusService;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import ch.iterate.mountainduck.sync.status.RenameInProgressStatusService;
import ch.iterate.mountainduck.sync.status.WriteInProgressStatusService;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultCacheDeleteCallback
implements CacheDeleteCallback {
    private static final Logger log = LogManager.getLogger((String)DefaultCacheDeleteCallback.class.getName());
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final FileHistory history;
    private final SyncQueue.Listener listener;

    public DefaultCacheDeleteCallback(Host bookmark, LocalCache<?> cache, MetadataService<?> metadata, FileHistory history, SyncQueue.Listener listener) {
        this.bookmark = bookmark;
        this.cache = cache;
        this.metadata = metadata;
        this.history = history;
        this.listener = listener;
    }

    @Override
    public boolean delete(long timestamp, Local local, Path file) throws BackgroundException {
        if (timestamp < MetadataStorage.Key.timestamp.fromDictionary(this.metadata.read(local, MetadataStorage.Key.timestamp))) {
            log.warn(String.format("Skip deleting file %s in cache with later timestamp in metadata than %d", file, timestamp));
            return false;
        }
        switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case ignored: 
            case local: {
                log.warn(String.format("Skip deleting file %s in cache with local only state", file));
                return false;
            }
        }
        switch (new WriteInProgressStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case inprogress: {
                log.warn(String.format("Skip delete of file %s with pending write operation in queue", file));
                return false;
            }
        }
        switch (new RenameInProgressStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case inprogress: {
                log.warn(String.format("Skip delete of file %s with pending rename operation in queue", file));
                return false;
            }
        }
        FileStatusService.Status error = new ErrorStatusService(this.cache, this.metadata).getStatus(file);
        block9 : switch (error.getState()) {
            case error: {
                log.warn(String.format("Error status %s for file %s", error, file));
                block12 : switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(local).getState()) {
                    case placeholder: {
                        if (file.isFile()) break block9;
                    }
                    default: {
                        Set failures = error.getExceptions();
                        Iterator iterator = failures.iterator();
                        while (iterator.hasNext()) {
                            SerializableOperationException failure = (SerializableOperationException)iterator.next();
                            SerializableOperation operation = failure.getOperation();
                            switch (operation.getOperation()) {
                                case write: {
                                    log.warn(String.format("Skip trashing file %s in cache with error %s for operation %s", local, failure, operation));
                                    return false;
                                }
                            }
                            break block12;
                        }
                        break block9;
                    }
                }
                {
                    continue;
                    break;
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Delete file %s in cache no longer found in remote directory listing", file));
        }
        Set purged = this.cache.trash(file);
        this.listener.fileStatusChanged(purged, Operation.delete, new FileStatusService.Status(FileStatusService.SyncState.unknown));
        this.history.add(new FileHistory.Item(file, this.cache.toMount(file), FileHistory.Item.Origin.remote, Operation.delete));
        if (PreferencesFactory.get().getBoolean("fs.sync.notification.delete")) {
            NotificationServiceFactory.get().notify(BookmarkNameProvider.toString((Host)this.bookmark), this.cache.toMount(file).getAbsolute(), LocaleFactory.localizedString((String)"File Deleted", (String)"Disk"), file.getName());
        }
        return !purged.isEmpty();
    }
}

