/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingAttributesFinderFeature;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConflictException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.TransferStatusCanceledException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.notification.DisabledNotificationService;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.DisabledAlertCallback;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.transfer.DisabledTransferPrompt;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.UploadTransfer;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.cyberduck.core.worker.ConcurrentTransferWorker;
import ch.cyberduck.core.worker.CreateDirectoryWorker;
import ch.cyberduck.core.worker.CreateSymlinkWorker;
import ch.cyberduck.core.worker.DeleteWorker;
import ch.cyberduck.core.worker.MoveWorker;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WriteTimestampWorker;
import ch.iterate.mountainduck.fs.FilesystemAclWorker;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemLockWorker;
import ch.iterate.mountainduck.fs.FilesystemPermissionWorker;
import ch.iterate.mountainduck.fs.FilesystemUnlockWorker;
import ch.iterate.mountainduck.fs.LockPatternService;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.QueueCoalescedCallback;
import ch.iterate.mountainduck.sync.queue.QueueDiscardCallback;
import ch.iterate.mountainduck.sync.queue.QueueErrorCallback;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.sync.queue.SyncQueueTransferErrorCallback;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueAttributesFinder;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueDeleteFilter;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueDownloadFilter;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueFindService;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueRenameFilter;
import ch.iterate.mountainduck.sync.queue.filter.SyncQueueUploadFilter;
import ch.iterate.mountainduck.threading.BlockingWorkerExecutor;
import ch.iterate.mountainduck.threading.WorkerExecutor;
import com.dd.plist.NSDictionary;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockingSyncQueue
implements SyncQueue {
    private static final Logger log = LogManager.getLogger((String)BlockingSyncQueue.class.getName());
    private final BackgroundActionRegistry registry = new BackgroundActionRegistry();
    private final Preferences preferences = PreferencesFactory.get();
    private final WorkerExecutor executor;
    private final Controller controller;
    private final SessionPool remote;
    private final LocalCache<?> cache;
    private final QueueLock<?> lock;
    private final MetadataService<?> metadata;
    private final FileHistory history;
    private final ReloadService reload;
    private final Set<SyncQueue.Listener> listeners = new HashSet<SyncQueue.Listener>();

    public BlockingSyncQueue(Controller controller, SessionPool fs, LocalCache<?> cache, QueueLock<?> lock, MetadataService<?> metadata, FileHistory history, ReloadService reload) {
        this.controller = controller;
        this.remote = fs;
        this.cache = cache;
        this.lock = lock;
        this.metadata = metadata;
        this.history = history;
        this.reload = reload;
        this.executor = new BlockingWorkerExecutor(controller, fs.getHost(), (AlertCallback)new DisabledAlertCallback(), this.registry);
    }

    public void purge(Local local, Path file) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Truncate file %s in cache", file));
        }
        try {
            if (((Boolean)this.metadata.write(local, MetadataStorage.Key.placeholder, new NSDictionary()).get()).booleanValue()) {
                this.metadata.flush(local);
                this.cache.truncate(file, 0L);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BackgroundException(e.getCause());
        }
    }

    public void read(Local local, Path file) throws BackgroundException {
        throw new UnsupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(List<TransferItem> items, final QueueDiscardCallback listener, QueueErrorCallback error) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Read files %s", items));
        }
        PathCache caching = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
        final DownloadFilterOptions options = new DownloadFilterOptions(this.remote.getHost());
        options.timestamp = true;
        DownloadTransfer transfer = new DownloadTransfer(this.remote.getHost(), items, (Cache)caching){
            final /* synthetic */ Cache val$caching;
            {
                this.val$caching = cache;
                super(host, roots);
            }

            public void normalize() {
            }

            public synchronized void reset() {
                super.reset();
                this.addSize(0L);
                this.addTransferred(0L);
            }

            public AbstractDownloadFilter filter(Session<?> source, Session<?> destination, TransferAction action, ProgressListener progressListener) {
                return new SyncQueueDownloadFilter(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.lock, BlockingSyncQueue.this.metadata, BlockingSyncQueue.this.history, BlockingSyncQueue.this.reload, source, options){

                    @Override
                    public void complete(Path file, Local local, TransferStatus status, ProgressListener progressListener) throws BackgroundException {
                        super.complete(file, local, status, progressListener);
                        if (status.isSegment()) {
                            return;
                        }
                        if (status.isComplete()) {
                            listener.operationDiscarded(new SerializableOperation[]{new SerializableOperation(Operation.read, local, file).withLength(status.getLength())});
                        }
                    }
                }.withAttributes(new SyncQueueAttributesFinder(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.metadata, (AttributesFinder)new CachingAttributesFinderFeature(this.val$caching, (AttributesFinder)source.getFeature(AttributesFinder.class, (Object)new DefaultAttributesFinderFeature(source)))));
            }
        }.withCache((Cache)caching);
        try {
            transfer.start();
            TransferSpeedometer meter = new TransferSpeedometer((Transfer)transfer);
            this.executor.run((Worker)new ConcurrentTransferWorker(this.remote, SessionPool.DISCONNECTED, (Transfer)transfer, ThreadPool.Priority.valueOf((String)this.preferences.getProperty("queue.download.thread.priority")), new TransferOptions(), meter, (TransferPrompt)new DisabledTransferPrompt(){

                public TransferAction prompt(TransferItem file) {
                    return TransferAction.comparison;
                }
            }, new SyncQueueTransferErrorCallback(Operation.read, error), (ConnectionCallback)LoginCallbackFactory.get((Controller)this.controller), new TransferProgressListener((Transfer)transfer), new TransferSpeedometerStreamListener(Operation.read, meter), (NotificationService)new DisabledNotificationService()){

                public Boolean initialize() {
                    return false;
                }
            }, this.remote);
        }
        finally {
            transfer.stop();
        }
    }

    public void write(Local local, Path file, Application application) throws BackgroundException {
        throw new UnsupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<TransferItem> items, QueueCoalescedCallback coalesce, final QueueDiscardCallback listener, QueueErrorCallback error, final Application application) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Write files %s", items));
        }
        PathCache caching = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
        Transfer transfer = new UploadTransfer(this.remote.getHost(), items, (Filter)new Filter<Local>(){

            public boolean accept(Local file) {
                return !FilesystemFilenameBlacklist.localonly.contains(file.getName());
            }

            public Pattern toPattern() {
                return null;
            }
        }, (Cache)caching){
            final /* synthetic */ Cache val$caching;
            {
                this.val$caching = cache;
                super(host, roots, f);
            }

            public void normalize() {
            }

            public synchronized void reset() {
                super.reset();
                this.addSize(0L);
                this.addTransferred(0L);
            }

            public List<TransferItem> list(Session<?> session, Path remote, Local directory, ListProgressListener progress) {
                return Collections.emptyList();
            }

            public AbstractUploadFilter filter(Session<?> source, Session<?> destination, TransferAction action, ProgressListener progress) {
                UploadFilterOptions options = new UploadFilterOptions(BlockingSyncQueue.this.remote.getHost()).withPermission(false).withTimestamp(true);
                return new SyncQueueUploadFilter(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.lock, BlockingSyncQueue.this.metadata, BlockingSyncQueue.this.history, BlockingSyncQueue.this.reload, source, options, application){

                    @Override
                    public void complete(Path file, Local local, TransferStatus status, ProgressListener progress) throws BackgroundException {
                        super.complete(file, local, status, progress);
                        if (status.isComplete()) {
                            listener.operationDiscarded(new SerializableOperation[]{new SerializableOperation(Operation.write, local, file).withLength(BlockingSyncQueue.this.cache.toCiphertextSize(status.getLength()))});
                        }
                    }
                }.withFinder(new SyncQueueFindService(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.metadata, (Find)new CachingFindFeature(this.val$caching, (Find)source.getFeature(Find.class, (Object)new DefaultFindFeature(source))))).withAttributes((AttributesFinder)new SyncQueueAttributesFinder(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.metadata, (AttributesFinder)new CachingAttributesFinderFeature(this.val$caching, (AttributesFinder)source.getFeature(AttributesFinder.class, (Object)new DefaultAttributesFinderFeature(source)))));
            }
        }.withCache((Cache)caching);
        try {
            transfer.start();
            TransferSpeedometer meter = new TransferSpeedometer(transfer);
            this.executor.run((Worker)new ConcurrentTransferWorker(this.remote, SessionPool.DISCONNECTED, transfer, ThreadPool.Priority.valueOf((String)this.preferences.getProperty("queue.upload.thread.priority")), new TransferOptions(), meter, (TransferPrompt)new DisabledTransferPrompt(){

                public TransferAction prompt(TransferItem item) {
                    return TransferAction.comparison;
                }
            }, new SyncQueueTransferErrorCallback(Operation.write, error), (ConnectionCallback)LoginCallbackFactory.get((Controller)this.controller), new TransferProgressListener(transfer), new TransferSpeedometerStreamListener(Operation.write, meter), (NotificationService)new DisabledNotificationService()){

                public Boolean initialize() {
                    return false;
                }
            }, this.remote);
        }
        finally {
            transfer.stop();
        }
    }

    public void rename(final Local lsource, final Local ltarget, final Path source, final Path target) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Rename file %s to %s", source, target));
        }
        this.executor.run((Worker)new MoveWorker(Collections.singletonMap(source, target), this.remote, (Cache)PathCache.empty(), (ProgressListener)new DisabledProgressListener(), (ConnectionCallback)LoginCallbackFactory.get((Controller)this.controller)){

            public Map<Path, Path> run(Session<?> session) throws BackgroundException {
                try {
                    PathCache caching = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
                    UploadFilterOptions options = new UploadFilterOptions(BlockingSyncQueue.this.remote.getHost()).withPermission(false).withAcl(false).withTimestamp(false);
                    AbstractUploadFilter filter = new SyncQueueRenameFilter(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.lock, BlockingSyncQueue.this.metadata, BlockingSyncQueue.this.history, BlockingSyncQueue.this.reload, session, options).withFinder(new SyncQueueFindService(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.metadata, (Find)session.getFeature(Find.class, (Object)new DefaultFindFeature(session)))).withAttributes((AttributesFinder)new SyncQueueAttributesFinder(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.metadata, (AttributesFinder)new CachingAttributesFinderFeature((Cache)caching, (AttributesFinder)session.getFeature(AttributesFinder.class, (Object)new DefaultAttributesFinderFeature(session)))));
                    TransferStatus status = filter.prepare(target, ltarget, new TransferStatus().exists(true), (ProgressListener)new DisabledProgressListener());
                    if (status.isExists()) {
                        filter.apply(target, ltarget, status, (ProgressListener)new DisabledProgressListener());
                    }
                    Map result = super.run(session);
                    for (Map.Entry entry : result.entrySet()) {
                        filter.complete((Path)entry.getValue(), BlockingSyncQueue.this.cache.toLocal((Path)entry.getValue()), status.complete(), (ProgressListener)new DisabledProgressListener());
                    }
                    BlockingSyncQueue.this.metadata.delete(lsource, MetadataStorage.Key.metadata);
                    Map map = result;
                    return map;
                }
                catch (BackgroundException failure) {
                    log.warn(String.format("Rename failed with error %s. Restore file %s in cache", new Object[]{failure, source}));
                    try {
                        BlockingSyncQueue.this.cache.rename(target, source);
                        BlockingSyncQueue.this.metadata.delete(ltarget, MetadataStorage.Key.metadata);
                    }
                    catch (BackgroundException e) {
                        log.error(String.format("Failure %s restoring placeholder %s in cache", new Object[]{e, source}));
                    }
                    BlockingSyncQueue.this.reload.reload(target.getParent(), BlockingSyncQueue.this.cache.toMount(target.getParent()), Collections.singletonMap(target, ReloadService.Change.added));
                    throw failure;
                }
                finally {
                    BlockingSyncQueue.this.metadata.delete(lsource, MetadataStorage.Key.rename);
                    BlockingSyncQueue.this.metadata.delete(ltarget, MetadataStorage.Key.rename);
                }
            }

            protected String getLockId(Path file) {
                return BlockingSyncQueue.this.cache.getLock(file);
            }

            public void cleanup(Map<Path, Path> result) {
                for (Path f : result.values()) {
                    BlockingSyncQueue.this.history.add(new FileHistory.Item(f, BlockingSyncQueue.this.cache.toMount(f), FileHistory.Item.Origin.local, Operation.rename));
                }
            }
        }, this.remote);
    }

    public void delete(Local local, Path target) throws BackgroundException {
        throw new UnsupportedException();
    }

    public void delete(List<TransferItem> items, QueueDiscardCallback listener) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Delete files %s", items));
        }
        this.delete(items.stream().filter(item -> FilesystemFilenameBlacklist.lockowner.contains(item.remote)).collect(Collectors.toList()), false, listener);
        this.delete(items.stream().filter(item -> !FilesystemFilenameBlacklist.lockowner.contains(item.remote)).collect(Collectors.toList()), true, listener);
    }

    private void delete(final List<TransferItem> items, boolean trash, final QueueDiscardCallback listener) throws BackgroundException {
        if (items.isEmpty()) {
            return;
        }
        this.executor.run((Worker)new DeleteWorker(LoginCallbackFactory.get((Controller)this.controller), items.stream().map(item -> item.remote).collect(Collectors.toList()), (ProgressListener)new DisabledProgressListener(), (Filter)new NullFilter(), trash, new Delete.Callback(){

            public void delete(Path f) {
                Optional<TransferItem> optional = items.stream().filter(item -> item.remote.equals((Object)f)).findFirst();
                optional.ifPresent(item -> listener.operationDiscarded(new SerializableOperation[]{new SerializableOperation(Operation.delete, item.local, item.remote)}));
            }
        }){

            public List<Path> run(Session<?> session) throws BackgroundException {
                PathCache caching = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
                UploadFilterOptions options = new UploadFilterOptions(BlockingSyncQueue.this.remote.getHost()).withPermission(false).withAcl(false).withTimestamp(false);
                AbstractUploadFilter filter = new SyncQueueDeleteFilter(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.lock, BlockingSyncQueue.this.metadata, BlockingSyncQueue.this.history, BlockingSyncQueue.this.reload, session, options).withFinder(new SyncQueueFindService(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.metadata, (Find)session.getFeature(Find.class, (Object)new DefaultFindFeature(session)))).withAttributes((AttributesFinder)new SyncQueueAttributesFinder(BlockingSyncQueue.this.remote.getHost(), BlockingSyncQueue.this.cache, BlockingSyncQueue.this.metadata, (AttributesFinder)new CachingAttributesFinderFeature((Cache)caching, (AttributesFinder)session.getFeature(AttributesFinder.class, (Object)new DefaultAttributesFinderFeature(session)))));
                try {
                    for (TransferItem item2 : items) {
                        TransferStatus status = filter.prepare(item2.remote, item2.local, new TransferStatus().exists(true), (ProgressListener)new DisabledProgressListener());
                        filter.apply(item2.remote, item2.local, status, (ProgressListener)new DisabledProgressListener());
                    }
                    List result = super.run(session);
                    for (Path f : result) {
                        Optional<TransferItem> optional = items.stream().filter(items -> items2.remote.equals((Object)f)).findFirst();
                        if (!optional.isPresent()) continue;
                        filter.complete(optional.get().remote, optional.get().local, new TransferStatus().complete(), (ProgressListener)new DisabledProgressListener());
                    }
                    List list = result;
                    return list;
                }
                catch (BackgroundException failure) {
                    for (TransferItem item3 : items) {
                        if (failure instanceof NotfoundException) {
                            log.warn(String.format("Delete failed with error %s. Trash file %s in cache", new Object[]{failure, item3.remote}));
                            BlockingSyncQueue.this.cache.trash(item3.remote);
                            continue;
                        }
                        log.warn(String.format("Delete failed with error %s. Restore file %s in cache", new Object[]{failure, item3.remote}));
                        BlockingSyncQueue.this.cache.placeholder(item3.remote, item3.remote.attributes());
                        BlockingSyncQueue.this.reload.reload(item3.remote.getParent(), BlockingSyncQueue.this.cache.toMount(item3.remote.getParent()), Collections.singletonMap(item3.remote, ReloadService.Change.added));
                    }
                    throw failure;
                }
                finally {
                    items.forEach(item -> BlockingSyncQueue.this.metadata.delete(item.local, MetadataStorage.Key.delete));
                }
            }

            public void cleanup(List<Path> deleted) {
                for (Path f : deleted) {
                    Optional<TransferItem> optional = items.stream().filter(items -> items2.remote.equals((Object)f)).findFirst();
                    optional.ifPresent(item -> BlockingSyncQueue.this.metadata.delete(item.local, MetadataStorage.Key.metadata));
                }
                super.cleanup(deleted);
            }

            protected String getLockId(Path file) {
                return BlockingSyncQueue.this.cache.getLock(file);
            }
        }, this.remote);
    }

    public void mkdir(Local local, final Path directory) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Create directory %s", directory));
        }
        this.executor.run((Worker)new CreateDirectoryWorker(directory, directory.attributes().getRegion()){

            public Path run(Session<?> session) throws BackgroundException {
                try {
                    Path result = super.run(session);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Set metadata for %s from %s", result, result.attributes()));
                    }
                    BlockingSyncQueue.this.cache.setattr(result, result.getType(), result.attributes());
                    return result;
                }
                catch (ConflictException e) {
                    log.warn(String.format("Ignore failure %s creating directory %s", new Object[]{e, directory}));
                    return null;
                }
            }

            public void cleanup(Path result) {
                BlockingSyncQueue.this.history.add(new FileHistory.Item(directory, BlockingSyncQueue.this.cache.toMount(directory), FileHistory.Item.Origin.local, Operation.mkdir));
            }
        }, this.remote);
    }

    public void timestamp(final Local local, final Path target, final Long timestamp) throws BackgroundException {
        this.executor.run((Worker)new WriteTimestampWorker(target, timestamp){

            public Boolean run(Session<?> session) throws BackgroundException {
                Timestamp feature = (Timestamp)session.getFeature(Timestamp.class);
                if (null == feature) {
                    return false;
                }
                try {
                    if (super.run(session).booleanValue()) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Update metadata for %s with timestamp %s", target, timestamp));
                        }
                        BlockingSyncQueue.this.cache.setattr(target, target.getType(), new PathAttributes(BlockingSyncQueue.this.cache.getattr(local).withModificationDate(timestamp.longValue())), true);
                        return true;
                    }
                    return false;
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Ignore failure %s setting timestamp for file %s", new Object[]{e, target}));
                    throw new TransferStatusCanceledException((Throwable)e);
                }
            }

            protected String getLockId(Path file) {
                return BlockingSyncQueue.this.cache.getLock(file);
            }
        }, this.remote);
    }

    public void chmod(final Local local, final Path target, final Permission permission) throws BackgroundException {
        this.executor.run((Worker)new FilesystemPermissionWorker(target, permission){

            public Boolean run(Session<?> session) throws BackgroundException {
                try {
                    if (super.run(session).booleanValue()) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Update metadata for %s with permission %s", target, permission));
                        }
                        BlockingSyncQueue.this.cache.setattr(target, target.getType(), new PathAttributes(BlockingSyncQueue.this.cache.getattr(local).withPermission(permission)), true);
                        return true;
                    }
                    return false;
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Ignore failure %s setting permission for file %s", new Object[]{e, target}));
                    throw new TransferStatusCanceledException((Throwable)e);
                }
            }
        }, this.remote);
        this.executor.run((Worker)new FilesystemAclWorker(target, permission){

            public Boolean run(Session<?> session) throws BackgroundException {
                try {
                    if (super.run(session).booleanValue()) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Update metadata for %s with ACL %s", target, permission));
                        }
                        BlockingSyncQueue.this.cache.setattr(target, target.getType(), new PathAttributes(BlockingSyncQueue.this.cache.getattr(local).withAcl(FilesystemAclWorker.toAcl((Permission)permission))), true);
                        return true;
                    }
                    return false;
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Ignore failure %s setting ACL for file %s", new Object[]{e, target}));
                    throw new TransferStatusCanceledException((Throwable)e);
                }
            }
        }, this.remote);
    }

    public void symlink(Local lsource, Local ltarget, Path source, Path target) throws BackgroundException {
        this.executor.run((Worker)new CreateSymlinkWorker(source, target.getAbsolute()){

            public Path run(Session<?> session) throws BackgroundException {
                Symlink feature = (Symlink)session.getFeature(Symlink.class);
                if (null == feature) {
                    throw new UnsupportedException(String.format("%s feature not supported for %s", Symlink.class.getName(), session.getHost().getProtocol()));
                }
                Path result = super.run(session);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Set metadata for %s from %s", result, result.attributes()));
                }
                BlockingSyncQueue.this.cache.setattr(result, result.getType(), result.attributes());
                return result;
            }
        }, this.remote);
    }

    public void lock(final Local local, final Path target) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Lock file %s", target));
        }
        this.executor.run((Worker)new FilesystemLockWorker(Collections.emptySet(), target){

            public String run(Session<?> session) throws BackgroundException {
                try {
                    String lockId = super.run(session);
                    if (lockId != null) {
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Locked file %s with id %s", target, lockId));
                        }
                        NSDictionary dict = new NSDictionary();
                        dict.put(MetadataStorage.Key.lockid.name(), (Object)lockId);
                        BlockingSyncQueue.this.metadata.write(local, MetadataStorage.Key.lockid, dict);
                    }
                    return lockId;
                }
                catch (LockedException e) {
                    log.warn(String.format("File %s is locked on server", target));
                    throw e;
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Ignore failure %s trying to obtain lock for %s", new Object[]{e, target}));
                    throw new TransferStatusCanceledException((Throwable)e);
                }
            }
        }, this.remote);
    }

    public void unlock(final Local local, final Path target, final String lockId) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Unlock file %s with id %s", target, lockId));
        }
        this.executor.run((Worker)new FilesystemUnlockWorker((FilesystemCallbacks)this.cache, Collections.emptySet(), target, lockId){

            public String run(Session<?> session) throws BackgroundException {
                String lockId2 = super.run(session);
                if (lockId2 != null) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Unlocked file %s with id %s", target, lockId2));
                    }
                    BlockingSyncQueue.this.metadata.delete(local, MetadataStorage.Key.lockid);
                    BlockingSyncQueue.this.cache.setattr(target, target.getType(), new PathAttributes(BlockingSyncQueue.this.cache.getattr(local).withLockId(null)));
                }
                return lockId2;
            }

            protected String unlock(Session<?> session, LockPatternService patterns) throws BackgroundException {
                Set locks = patterns.derive(target);
                for (Path lock : locks) {
                    try {
                        BlockingSyncQueue.this.cache.find(target.getParent(), lock.getName());
                        log.warn(String.format("Found lock owner file %s matching file %s", locks, target));
                        return null;
                    }
                    catch (NotfoundException e) {
                        log.debug(String.format("No lock owner file %s found", lock));
                    }
                }
                return lockId;
            }
        }, this.remote);
    }

    public List<SerializableOperation> find(int n) {
        return Collections.emptyList();
    }

    public boolean contains(Path file) {
        return false;
    }

    public Set<SerializableOperation> get(Local local) {
        return Collections.emptySet();
    }

    public SyncQueue.Status getStatus() {
        return SyncQueue.Status.idle;
    }

    public SyncQueue.Status getStatus(Path file) {
        return SyncQueue.Status.idle;
    }

    public boolean submit(SerializableOperation operation) {
        return false;
    }

    public void flush() {
    }

    public void close() {
        for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
            if (action == null) continue;
            action.cancel();
        }
        this.listeners.clear();
        this.executor.shutdown();
    }

    public SyncQueue open() {
        return this;
    }

    public Future<Boolean> pause(SyncQueue.Status cause, BackgroundException failure) {
        this.executor.shutdown();
        return ConcurrentUtils.constantFuture((Object)false);
    }

    public Future<Boolean> resume() {
        return ConcurrentUtils.constantFuture((Object)false);
    }

    public int size() {
        return 0;
    }

    public SyncQueue.Stats stats() {
        return SyncQueue.Stats.IDLE;
    }

    public void beginQueueing(Path remote, Local local) {
    }

    public void endQueueing(Path remote, Local local) {
    }

    public SyncQueue withListener(SyncQueue.Listener listener) {
        this.listeners.add(listener);
        return this;
    }

    private final class TransferProgressListener
    implements ProgressListener {
        private final Transfer transfer;

        public TransferProgressListener(Transfer transfer) {
            this.transfer = transfer;
        }

        public void message(String message) {
            for (SyncQueue.Listener listener : BlockingSyncQueue.this.listeners) {
                listener.transferStatusChanged(new TransferProgress(this.transfer.getSize(), this.transfer.getTransferred(), message, Double.valueOf(0.0)));
            }
        }
    }

    private final class TransferSpeedometerStreamListener
    implements StreamListener {
        private final Operation operation;
        private final TransferSpeedometer meter;
        private final boolean plain;

        public TransferSpeedometerStreamListener(Operation operation, TransferSpeedometer meter) {
            this.plain = BlockingSyncQueue.this.preferences.getBoolean("menu.sync.queue.progress.bytes.enable");
            this.operation = operation;
            this.meter = meter;
        }

        public void sent(long bytes) {
            switch (this.operation) {
                case write: {
                    for (SyncQueue.Listener listener : BlockingSyncQueue.this.listeners) {
                        listener.transferStatusChanged(this.meter.getStatus(this.plain));
                    }
                    break;
                }
            }
        }

        public void recv(long bytes) {
            switch (this.operation) {
                case read: {
                    for (SyncQueue.Listener listener : BlockingSyncQueue.this.listeners) {
                        listener.transferStatusChanged(this.meter.getStatus(this.plain));
                    }
                    break;
                }
            }
        }
    }
}

