/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.lock;

import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadLocalQueueLock
implements QueueLock<Boolean> {
    private static final Logger log = LogManager.getLogger((String)ThreadLocalQueueLock.class.getName());
    private final Map<Path, ThreadLocal<Boolean>> reserved = new HashMap<Path, ThreadLocal<Boolean>>();

    @Override
    public synchronized Boolean acquire(Path file, QueueLock.Option option) {
        if (this.reserved.containsKey(file)) {
            return this.lock(file, this.reserved.get(file));
        }
        for (Map.Entry<Path, ThreadLocal<Boolean>> entry : this.reserved.entrySet()) {
            Path f = entry.getKey();
            ThreadLocal<Boolean> lock = entry.getValue();
            if (file.equals((Object)f)) {
                return this.lock(file, lock);
            }
            if (option != QueueLock.Option.branch) continue;
            if (f.isChild(file)) {
                return this.lock(file, lock);
            }
            if (!file.isChild(f)) continue;
            return this.lock(file, lock);
        }
        ThreadLocal<Boolean> lock = ThreadLocal.withInitial(() -> false);
        lock.set(true);
        return this.lock(file, lock);
    }

    protected boolean lock(Path file, ThreadLocal<Boolean> lock) {
        if (!lock.get().booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Deny lock for %s already acquired", file));
            }
            return false;
        }
        this.reserved.put(file, lock);
        if (log.isInfoEnabled()) {
            log.info(String.format("Acquired lock for %s", file));
        }
        return true;
    }

    @Override
    public synchronized void release(Path file) {
        this.reserved.remove(file);
    }

    @Override
    public synchronized void clear() {
        this.reserved.clear();
    }
}

