/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.lock;

import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReentrantQueueLock
implements QueueLock<Boolean> {
    private static final Logger log = LogManager.getLogger((String)ReentrantQueueLock.class.getName());
    private final Lock sync = new ReentrantLock();
    private final Map<FilesystemCacheReference, LockWithOption> reserved = new ConcurrentHashMap<FilesystemCacheReference, LockWithOption>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean acquire(Path file, QueueLock.Option option) {
        this.sync.lock();
        try {
            ReentrantLock lock;
            for (Map.Entry reference2 : this.reserved.entrySet().stream().filter(reference -> new LockPathBranchPredicate(file).test(((FilesystemCacheReference)reference.getKey()).getFile())).collect(Collectors.toSet())) {
                if (((LockWithOption)reference2.getValue()).option != QueueLock.Option.branch || (lock = ((LockWithOption)reference2.getValue()).impl).tryLock()) continue;
                Boolean bl = false;
                return bl;
            }
            Object predicate = option == QueueLock.Option.branch ? new LockPathBranchPredicate(file) : new LockPathSinglePredicate(file);
            Optional<FilesystemCacheReference> optionQuery = this.reserved.keySet().stream().filter(arg_0 -> ReentrantQueueLock.lambda$acquire$1((CacheReference)predicate, arg_0)).findFirst();
            if (optionQuery.isPresent()) {
                lock = this.reserved.get((Object)optionQuery.get()).impl;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("New lock for file %s", file));
                }
                lock = new ReentrantLock();
            }
            if (!lock.tryLock()) {
                Boolean bl = false;
                return bl;
            }
            if (this.reserved.containsKey(new FilesystemCacheReference(file))) {
                log.warn(String.format("Unexpected existing lock for %s", file));
            }
            this.reserved.put(new FilesystemCacheReference(file), new LockWithOption(lock, option));
            if (log.isInfoEnabled()) {
                log.info(String.format("Acquired lock for %s", file));
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void release(Path file) {
        this.sync.lock();
        try {
            LockWithOption lock = this.reserved.get(new FilesystemCacheReference(file));
            if (null == lock) {
                log.error(String.format("Missing lock for file %s", file));
                return;
            }
            if (!lock.impl.isHeldByCurrentThread()) {
                log.warn(String.format("Lock %s not held by current thread", lock));
                return;
            }
            if (null == this.reserved.remove(new FilesystemCacheReference(file))) {
                log.error(String.format("Failure releasing %s from reserved locks", file));
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("Released lock for %s", file));
            }
            lock.impl.unlock();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void clear() {
        this.sync.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Clear reserved locks");
            }
            this.reserved.clear();
        }
        finally {
            this.sync.unlock();
        }
    }

    private static /* synthetic */ boolean lambda$acquire$1(CacheReference predicate, FilesystemCacheReference reference) {
        return predicate.test((Object)reference.getFile());
    }

    private static final class LockWithOption {
        public final ReentrantLock impl;
        public final QueueLock.Option option;

        public LockWithOption(ReentrantLock impl, QueueLock.Option option) {
            this.impl = impl;
            this.option = option;
        }
    }

    public static final class LockPathBranchPredicate
    implements CacheReference<Path> {
        private final Path file;

        public LockPathBranchPredicate(Path file) {
            this.file = file;
        }

        public boolean test(Path f) {
            if (f.isChild(this.file)) {
                return true;
            }
            if (this.file.isChild(f)) {
                return true;
            }
            return this.file.equals((Object)f);
        }
    }

    public static final class LockPathSinglePredicate
    implements CacheReference<Path> {
        private final Path file;

        public LockPathSinglePredicate(Path file) {
            this.file = file;
        }

        public boolean test(Path f) {
            return this.file.equals((Object)f);
        }
    }

    public static enum Type {
        simple,
        withparent;

    }
}

