/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.lock;

import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockingQueueLock
implements QueueLock<Boolean> {
    private static final Logger log = LogManager.getLogger((String)BlockingQueueLock.class.getName());
    private final Lock sync = new ReentrantLock();
    private final Condition condition = this.sync.newCondition();
    private final QueueLock<Boolean> delegate;

    public BlockingQueueLock(QueueLock<Boolean> delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean acquire(Path file, QueueLock.Option option) {
        this.sync.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Acquire lock for %s with option %s", new Object[]{file, option}));
            }
            while (!this.delegate.acquire(file, option).booleanValue()) {
                log.warn(String.format("Await lock for %s with option %s", new Object[]{file, option}));
                this.condition.await(1L, TimeUnit.SECONDS);
            }
            Boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            log.error("Interrupted waiting for lock", (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void release(Path file) {
        this.sync.lock();
        try {
            this.delegate.release(file);
            this.condition.signalAll();
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

