/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.indexer;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.indexer.DirectoryIndexerVisitorCallback;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.SyncQueuePauseDiagnostics;
import ch.iterate.mountainduck.sync.indexer.PriorityCompletionService;
import ch.iterate.mountainduck.sync.indexer.TaskBackgroundAction;
import ch.iterate.mountainduck.sync.indexer.ThreadPoolPriorityCallable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadedDirectoryIndexer
implements DirectoryIndexer {
    private static final Logger log = LogManager.getLogger((String)ThreadedDirectoryIndexer.class.getName());
    private final ThreadPool pool;
    private final CompletionService<Void> completion;
    private final DirectoryIndexer proxy;
    private final BackgroundActionRegistry registry;
    private final Lock sync = new ReentrantLock();
    private DirectoryIndexer.Status status = PreferencesFactory.get().getBoolean("fs.sync.queue.paused") ? DirectoryIndexer.Status.paused : DirectoryIndexer.Status.idle;

    public ThreadedDirectoryIndexer(DirectoryIndexer proxy) {
        this(proxy, new BackgroundActionRegistry(), PreferencesFactory.get().getInteger("fs.sync.indexer.pool.size"), ThreadPool.Priority.valueOf((String)PreferencesFactory.get().getProperty("fs.sync.indexer.pool.priority")));
    }

    public ThreadedDirectoryIndexer(DirectoryIndexer proxy, BackgroundActionRegistry registry, int concurrency, ThreadPool.Priority priority) {
        this.proxy = proxy;
        this.registry = registry;
        this.pool = ThreadPoolFactory.get((String)"directory-indexer", (int)concurrency, (ThreadPool.Priority)priority, new PriorityBlockingQueue(concurrency), (Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler());
        this.completion = new PriorityCompletionService<Void>(this.pool.executor());
    }

    public void flush() {
        while (this.registry.size() > 0) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Await completion for %d submitted tasks in indexer", this.registry.size()));
            }
            try {
                Future<Void> future = this.completion.poll(1L, TimeUnit.SECONDS);
                if (null == future) continue;
                future.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn(String.format("Unhandled failure %s", e));
            }
            catch (TimeoutException timeoutException) {}
        }
    }

    public void shutdown() {
        for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
            if (action == null) continue;
            action.cancel();
        }
        this.proxy.shutdown();
        this.pool.shutdown(false);
        this.registry.clear();
        this.status = DirectoryIndexer.Status.idle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pause(DirectoryIndexer.Status cause, BackgroundException failure) {
        this.sync.lock();
        try {
            switch (this.status) {
                case idle: {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Pause indexer %s with failure %s", new Object[]{this.proxy, failure}));
                    }
                    BackgroundAction[] backgroundActionArray = (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()]);
                    int n = backgroundActionArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            this.registry.clear();
                            this.status = cause;
                            this.proxy.pause(cause, failure);
                            return;
                        }
                        BackgroundAction action = backgroundActionArray[n2];
                        if (action != null) {
                            action.cancel();
                        }
                        ++n2;
                    }
                }
            }
            return;
        }
        finally {
            this.sync.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resume() {
        this.sync.lock();
        try {
            switch (this.status) {
                case stopped: 
                case paused: {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Resume indexer %s", this.proxy));
                    }
                    this.proxy.resume();
                    this.status = DirectoryIndexer.Status.idle;
                    return;
                }
            }
            return;
        }
        finally {
            this.sync.unlock();
        }
    }

    public DirectoryIndexer.Status getStatus() {
        switch (this.status) {
            case idle: {
                return this.registry.size() == 0 ? this.proxy.getStatus() : DirectoryIndexer.Status.busy;
            }
        }
        return this.status;
    }

    public DirectoryIndexer.Stats stats() {
        return new DirectoryIndexer.Stats(this.registry.size());
    }

    public DirectoryIndexer withListener(DirectoryIndexer.Listener listener) {
        this.proxy.withListener(listener);
        return this;
    }

    public void index(final Path directory, final DirectoryIndexerVisitorCallback visitor, final ThreadPool.Priority priority, final ReloadService reload) throws BackgroundException {
        ThreadPoolPriorityCallable task = new ThreadPoolPriorityCallable(priority, directory){

            @Override
            public Void call() {
                try {
                    block2 : switch (ThreadedDirectoryIndexer.this.status) {
                        case stopped: 
                        case paused: {
                            log.debug(String.format("Skip indexing directory %s because of status %s", directory, ThreadedDirectoryIndexer.this.status));
                            break;
                        }
                        default: {
                            try {
                                ThreadedDirectoryIndexer.this.proxy.index(directory, visitor, priority, reload);
                                break;
                            }
                            catch (BackgroundException failure) {
                                log.warn(String.format("Failure %s updating index for directory %s", new Object[]{failure, directory}));
                                switch (new SyncQueuePauseDiagnostics().determine(failure)) {
                                    case cancel: {
                                        ThreadedDirectoryIndexer.this.pause(DirectoryIndexer.Status.stopped, failure);
                                        break block2;
                                    }
                                }
                                log.warn(String.format("Ignore indexer failure %s", new Object[]{failure}));
                            }
                        }
                    }
                    Void void_ = null;
                    return void_;
                }
                finally {
                    ThreadedDirectoryIndexer.this.registry.remove((Object)new TaskBackgroundAction(this));
                }
            }
        };
        if (log.isDebugEnabled()) {
            log.debug(String.format("Index directory %s", directory));
        }
        this.submit(new TaskBackgroundAction(task));
    }

    public void cache(final Path file, final DirectoryIndexerVisitorCallback visitor) {
        ThreadPoolPriorityCallable task = new ThreadPoolPriorityCallable(ThreadPool.Priority.max, file){

            @Override
            public Void call() {
                try {
                    ThreadedDirectoryIndexer.this.proxy.cache(file, new DirectoryIndexerVisitorCallback(){

                        public void visit(Path f) {
                            if (f.isDirectory()) {
                                ThreadedDirectoryIndexer.this.cache(f, visitor);
                            }
                            visitor.visit(f);
                        }

                        public void finish(Path directory) {
                            visitor.finish(directory);
                        }
                    });
                    Void void_ = null;
                    return void_;
                }
                finally {
                    ThreadedDirectoryIndexer.this.registry.remove((Object)new TaskBackgroundAction(this));
                }
            }
        };
        if (!this.registry.contains((Object)new TaskBackgroundAction(task))) {
            if (log.isInfoEnabled()) {
                log.debug(String.format("Cache file %s", file));
            }
            this.submit(new TaskBackgroundAction(task));
        }
    }

    protected Future<Void> submit(TaskBackgroundAction action) {
        this.registry.add((BackgroundAction)action);
        return this.completion.submit(action.getTask());
    }

    public void purge(final Path file) {
        ThreadPoolPriorityCallable task = new ThreadPoolPriorityCallable(ThreadPool.Priority.max, file){

            @Override
            public Void call() {
                try {
                    ThreadedDirectoryIndexer.this.proxy.purge(file);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    ThreadedDirectoryIndexer.this.registry.remove((Object)new TaskBackgroundAction(this));
                }
            }
        };
        if (!this.registry.contains((Object)new TaskBackgroundAction(task))) {
            if (log.isInfoEnabled()) {
                log.debug(String.format("Purge file %s", file));
            }
            this.submit(new TaskBackgroundAction(task));
        }
    }
}

