/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.indexer;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.NamedThreadFactory;
import ch.cyberduck.core.threading.ThreadPool;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.indexer.DirectoryIndexerVisitorCallback;
import ch.iterate.mountainduck.service.ReloadService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReschedulingDirectoryIndexer
implements DirectoryIndexer {
    private static final Logger log = LogManager.getLogger((String)ReschedulingDirectoryIndexer.class.getName());
    private final DirectoryIndexer proxy;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("directory-indexer-scheduler"));

    public ReschedulingDirectoryIndexer(DirectoryIndexer proxy) {
        this.proxy = proxy;
    }

    public void index(final Path directory, final DirectoryIndexerVisitorCallback visitor, final ThreadPool.Priority priority, final ReloadService reload) throws BackgroundException {
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                switch (ReschedulingDirectoryIndexer.this.proxy.getStatus()) {
                    case stopped: 
                    case paused: {
                        log.warn(String.format("Skip scheduling indexer because of status %s", ReschedulingDirectoryIndexer.this.proxy.getStatus()));
                        return;
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info(String.format("Run indexer %s for %s with callback %s", ReschedulingDirectoryIndexer.this.proxy, directory, visitor));
                }
                try {
                    ReschedulingDirectoryIndexer.this.proxy.index(directory, visitor, priority, reload);
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Unhandled failure %s", new Object[]{e}));
                }
                if (log.isInfoEnabled()) {
                    log.info(String.format("Wait for indexer %s to complete indexing %s", ReschedulingDirectoryIndexer.this.proxy, directory));
                }
                ReschedulingDirectoryIndexer.this.proxy.flush();
                if (log.isInfoEnabled()) {
                    log.info(String.format("Reschedule indexing %s after flush", directory));
                }
            }
        }, 0L, PreferencesFactory.get().getLong("fs.sync.indexer.period.seconds"), TimeUnit.SECONDS);
    }

    public void cache(Path file, DirectoryIndexerVisitorCallback visitor) {
        this.proxy.cache(file, visitor);
    }

    public void purge(Path file) {
        this.proxy.purge(file);
    }

    public void flush() {
        this.proxy.flush();
    }

    public void shutdown() {
        this.executor.shutdownNow();
        this.proxy.shutdown();
    }

    public void pause(DirectoryIndexer.Status cause, BackgroundException failure) {
        this.proxy.pause(cause, failure);
    }

    public void resume() {
        this.proxy.resume();
    }

    public DirectoryIndexer.Status getStatus() {
        return this.proxy.getStatus();
    }

    public DirectoryIndexer.Stats stats() {
        return this.proxy.stats();
    }

    public DirectoryIndexer withListener(DirectoryIndexer.Listener listener) {
        this.proxy.withListener(listener);
        return this;
    }
}

