/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.indexer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.threading.ThreadPool;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.indexer.DirectoryIndexerVisitorCallback;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.conflict.DirectoryConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecursiveDirectoryIndexer
implements DirectoryIndexer {
    private static final Logger log = LogManager.getLogger((String)RecursiveDirectoryIndexer.class.getName());
    private final Host bookmark;
    private final DirectoryIndexer proxy;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;

    public RecursiveDirectoryIndexer(Host bookmark, DirectoryIndexer proxy, LocalCache<?> local, MetadataService<?> metadata) {
        this.bookmark = bookmark;
        this.proxy = proxy;
        this.cache = local;
        this.metadata = metadata;
    }

    public void shutdown() {
        this.proxy.shutdown();
    }

    public void pause(DirectoryIndexer.Status cause, BackgroundException failure) {
        this.proxy.pause(cause, failure);
    }

    public void resume() {
        this.proxy.resume();
    }

    public DirectoryIndexer.Status getStatus() {
        return this.proxy.getStatus();
    }

    public DirectoryIndexer.Stats stats() {
        return this.proxy.stats();
    }

    public DirectoryIndexer withListener(DirectoryIndexer.Listener listener) {
        this.proxy.withListener(listener);
        return this;
    }

    public void flush() {
        this.proxy.flush();
    }

    public void index(Path directory, final DirectoryIndexerVisitorCallback visitor, ThreadPool.Priority priority, final ReloadService reload) throws BackgroundException {
        this.proxy.index(directory, new DirectoryIndexerVisitorCallback(){

            public void visit(Path file) {
                if (file.isDirectory()) {
                    switch (new PlaceholderStatusService(RecursiveDirectoryIndexer.this.cache, RecursiveDirectoryIndexer.this.metadata).getStatus(file).getState()) {
                        case synced: {
                            switch (new DirectoryConflictResolutionStrategy(RecursiveDirectoryIndexer.this.bookmark, RecursiveDirectoryIndexer.this.metadata).resolve(RecursiveDirectoryIndexer.this.cache.toLocal(file), file.attributes())) {
                                case local: 
                                case equal: {
                                    log.warn(String.format("Skip indexing directory %s with attributes %s", file, file.attributes()));
                                    return;
                                }
                            }
                        }
                    }
                    switch (RecursiveDirectoryIndexer.this.proxy.getStatus()) {
                        case stopped: 
                        case paused: {
                            break;
                        }
                        default: {
                            if (!new FilesystemListFilter().accept(file)) {
                                log.warn(String.format("Skip indexing directory %s with duplicate flag", file));
                                return;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Recursively index directory %s", file));
                            }
                            try {
                                RecursiveDirectoryIndexer.this.index(file, visitor, ThreadPool.Priority.low, reload);
                                break;
                            }
                            catch (BackgroundException e) {
                                log.warn(String.format("Unhandled failure %s", new Object[]{e}));
                            }
                        }
                    }
                }
                visitor.visit(file);
            }

            public void finish(Path directory) {
                visitor.finish(directory);
            }
        }, ThreadPool.Priority.low, reload);
    }

    public void cache(Path file, DirectoryIndexerVisitorCallback visitor) {
        this.proxy.cache(file, visitor);
    }

    public void purge(Path file) {
        this.proxy.purge(file);
    }
}

