/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.indexer;

import ch.iterate.mountainduck.sync.indexer.PriorityCallable;
import ch.iterate.mountainduck.sync.indexer.PriorityFutureTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PriorityCompletionService<V>
implements CompletionService<V> {
    private static final Logger log = LogManager.getLogger(PriorityCompletionService.class);
    private final ExecutorService executor;
    private final BlockingQueue<Future<V>> queue;

    public PriorityCompletionService(ExecutorService executor) {
        this(executor, new LinkedBlockingQueue<Future<V>>());
    }

    public PriorityCompletionService(ExecutorService executor, BlockingQueue<Future<V>> queue) {
        this.executor = executor;
        this.queue = queue;
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        PriorityFutureTask f = new PriorityFutureTask((PriorityCallable)task);
        this.executor.execute(new QueueingFuture(f));
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.queue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.queue.poll();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.poll(timeout, unit);
    }

    private final class QueueingFuture
    extends FutureTask<Void>
    implements Comparable<QueueingFuture> {
        private final PriorityFutureTask<V> task;

        private QueueingFuture(PriorityFutureTask<V> task) {
            super(task, null);
            this.task = task;
        }

        @Override
        protected void done() {
            if (log.isInfoEnabled()) {
                log.info(String.format("Add finished task %s to completion queue", this.task));
            }
            PriorityCompletionService.this.queue.add(this.task);
        }

        @Override
        public int compareTo(QueueingFuture o) {
            return this.task.compareTo(o.task);
        }
    }
}

