/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.indexer;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.worker.SessionListWorker;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexingListWorker
extends SessionListWorker {
    private static final Logger log = LogManager.getLogger((String)IndexingListWorker.class.getName());
    private final Path directory;
    private final FilesystemListProgressListener listener;

    public IndexingListWorker(Path directory, FilesystemListProgressListener listener) {
        super((Cache)PathCache.empty(), directory, (ListProgressListener)listener);
        this.directory = directory;
        this.listener = listener;
    }

    public AttributedList<Path> run(Session<?> session) throws BackgroundException {
        try {
            this.listener.reset();
            return super.run(session).filter((Filter)new FilesystemListFilter());
        }
        catch (BackgroundException e) {
            log.warn(String.format("Notify listener %s of error %s", new Object[]{this.listener, e}));
            this.listener.error(e);
            throw e;
        }
    }

    public void cleanup(AttributedList<Path> list) {
        super.cleanup(list);
        if (AttributedList.emptyList() == list) {
            log.warn(String.format("Cancel cleanup of worker for %s", this.directory));
            this.listener.error((BackgroundException)new ConnectionCanceledException());
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Notify listener %s for %s", this.listener, this.directory));
        }
        if (this.isCanceled()) {
            log.warn(String.format("Notify listener %s with partial directory listing for %s", this.listener, this.directory));
            this.listener.error((BackgroundException)new ListCanceledException(list));
        }
        this.listener.finish();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IndexingListWorker{");
        sb.append("directory=").append(this.directory);
        sb.append(", listener=").append(this.listener);
        sb.append('}');
        return sb.toString();
    }
}

