/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.indexer;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.DisabledAlertCallback;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.DisabledFilesystemListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemIncrementalListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.fs.SyncListProgressListener;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.indexer.DirectoryIndexerVisitorCallback;
import ch.iterate.mountainduck.service.CacheInvalidatingReloadService;
import ch.iterate.mountainduck.service.DisabledReloadService;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.indexer.IndexingListWorker;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.option.SyncOption;
import ch.iterate.mountainduck.sync.queue.CacheDeleteCallback;
import ch.iterate.mountainduck.sync.queue.CachePlaceholderCallback;
import ch.iterate.mountainduck.sync.queue.CacheSetattrCallback;
import ch.iterate.mountainduck.sync.queue.QueueIndexCallback;
import ch.iterate.mountainduck.sync.queue.QueueReadCallback;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.threading.BlockingWorkerExecutor;
import ch.iterate.mountainduck.threading.WorkerExecutor;
import com.dd.plist.NSDictionary;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockingDirectoryIndexer
implements DirectoryIndexer {
    private static final Logger log = LogManager.getLogger((String)BlockingDirectoryIndexer.class.getName());
    private final BackgroundActionRegistry registry = new BackgroundActionRegistry();
    private final SessionPool remote;
    private final LocalCache<?> cache;
    private final SyncOption option;
    private final MetadataService<?> metadata;
    private final FileHistory history;
    private final SyncQueue queue;
    private final FilesystemDirectoryGenerations generations;
    private final WorkerExecutor executor;
    private final Set<DirectoryIndexer.Listener> listeners = new HashSet<DirectoryIndexer.Listener>();
    private final QueueReadCallback readCallback;
    private final CacheDeleteCallback deleteCallback;
    private final CachePlaceholderCallback placeholderCallback;
    private final CacheSetattrCallback setAttrCallback;
    private final QueueLock<Boolean> lock;

    public BlockingDirectoryIndexer(Controller controller, SessionPool remote, LocalCache<?> cache, QueueLock<Boolean> lock, SyncOption option, MetadataService<?> metadata, FileHistory history, SyncQueue queue, FilesystemDirectoryGenerations generations, QueueReadCallback readCallback, CacheDeleteCallback deleteCallback, CacheSetattrCallback setAttrCallback, CachePlaceholderCallback placeholderCallback) {
        this.remote = remote;
        this.cache = cache;
        this.lock = lock;
        this.option = option;
        this.metadata = metadata;
        this.history = history;
        this.queue = queue;
        this.generations = generations;
        this.readCallback = readCallback;
        this.deleteCallback = deleteCallback;
        this.setAttrCallback = setAttrCallback;
        this.placeholderCallback = placeholderCallback;
        this.executor = new BlockingWorkerExecutor(controller, remote.getHost(), (AlertCallback)new DisabledAlertCallback(), this.registry);
    }

    public void shutdown() {
        for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
            if (action == null) continue;
            action.cancel();
        }
        this.executor.shutdown();
    }

    public void pause(DirectoryIndexer.Status cause, BackgroundException failure) {
        for (DirectoryIndexer.Listener listener : this.listeners) {
            listener.indexerStatusChanged(cause, failure);
        }
    }

    public void resume() {
    }

    public DirectoryIndexer.Status getStatus() {
        return DirectoryIndexer.Status.idle;
    }

    public DirectoryIndexer.Stats stats() {
        return DirectoryIndexer.Stats.IDLE;
    }

    public DirectoryIndexer withListener(DirectoryIndexer.Listener listener) {
        this.listeners.add(listener);
        return this;
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(final Path directory, final DirectoryIndexerVisitorCallback callback, ThreadPool.Priority priority, ReloadService reload) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.debug(String.format("Index directory %s with callback %s", directory, callback));
        }
        for (DirectoryIndexer.Listener l : this.listeners) {
            l.indexerStatusChanged(DirectoryIndexer.Status.busy);
        }
        try {
            SyncListProgressListener listener = new SyncListProgressListener(this.remote.getHost(), directory, this.cache, this.lock, this.option, this.metadata, this.history, (FilesystemListProgressListener)new DisabledFilesystemListProgressListener(), (ReloadService)new CacheInvalidatingReloadService(this.generations, reload), this.readCallback, new QueueIndexCallback(){

                public void index(Local local, Path file) {
                }
            }, this.setAttrCallback, this.deleteCallback, this.placeholderCallback){

                @Override
                public void finish() {
                    callback.finish(directory);
                    super.finish();
                }

                @Override
                public void visit(AttributedList<Path> list, int index, Path file) throws ConnectionCanceledException {
                    callback.visit(file);
                    super.visit(list, index, file);
                }
            };
            this.executor.run((Worker)new IndexingListWorker(directory, listener), this.remote);
        }
        finally {
            for (DirectoryIndexer.Listener l : this.listeners) {
                l.indexerStatusChanged(DirectoryIndexer.Status.idle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Path file, DirectoryIndexerVisitorCallback callback) {
        for (DirectoryIndexer.Listener l : this.listeners) {
            l.indexerStatusChanged(DirectoryIndexer.Status.busy);
        }
        this.metadata.write(this.cache.toLocal(file), MetadataStorage.Key.sync, new NSDictionary());
        this.queue.beginQueueing(file, this.cache.toLocal(file));
        try {
            this._cache(file, callback);
        }
        finally {
            this.queue.endQueueing(file, this.cache.toLocal(file));
            for (DirectoryIndexer.Listener l : this.listeners) {
                l.indexerStatusChanged(DirectoryIndexer.Status.idle);
            }
        }
    }

    private void _cache(Path file, final DirectoryIndexerVisitorCallback callback) {
        if (file.isDirectory()) {
            try {
                this.index(file, new DirectoryIndexerVisitorCallback(){

                    public void visit(Path f) {
                        BlockingDirectoryIndexer.this.metadata.write(BlockingDirectoryIndexer.this.cache.toLocal(f), MetadataStorage.Key.sync, new NSDictionary());
                        callback.visit(f);
                    }

                    public void finish(Path directory) {
                        callback.finish(directory);
                    }
                }, ThreadPool.Priority.max, (ReloadService)new DisabledReloadService());
            }
            catch (BackgroundException e) {
                log.warn(String.format("Unhandled failure %s", new Object[]{e}));
            }
        } else {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Download file %s in cache", file));
                }
                this.queue.read(this.cache.toLocal(file), file);
            }
            catch (BackgroundException e) {
                log.warn(String.format("Failure caching file %s", file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(Path file) {
        for (DirectoryIndexer.Listener l : this.listeners) {
            l.indexerStatusChanged(DirectoryIndexer.Status.busy);
        }
        this.queue.beginQueueing(file, this.cache.toLocal(file));
        try {
            this._purge(file, this.cache.toLocal(file));
        }
        finally {
            this.queue.endQueueing(file, this.cache.toLocal(file));
            for (DirectoryIndexer.Listener l : this.listeners) {
                l.indexerStatusChanged(DirectoryIndexer.Status.idle);
            }
        }
    }

    private void _purge(Path file, Local local) {
        if (local.exists()) {
            Path f = file;
            do {
                this.metadata.delete(this.cache.toLocal(f), MetadataStorage.Key.sync);
            } while (!f.isRoot() && (this.cache.toLocal(f = f.getParent()).isChild(this.cache.getDirectory()) || this.cache.toLocal(f).equals((Object)this.cache.getDirectory())));
            if (file.isDirectory()) {
                FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(new Host((Protocol)new LocalProtocol()));
                try {
                    Path next;
                    this.cache.list(file, (FilesystemListProgressListener)listener, 0L);
                    while ((next = listener.next()) != null) {
                        this._purge(next, this.cache.toLocal(next));
                    }
                }
                catch (BackgroundException e) {
                    log.error(String.format("Failure %s listing directory %s", new Object[]{e, local}));
                }
            } else {
                try {
                    log.warn(String.format("Truncate file %s in cache", local));
                    this.queue.purge(local, file);
                }
                catch (BackgroundException e) {
                    log.error(String.format("Failure %s removing file %s from cache", new Object[]{e, local}));
                }
            }
        }
    }
}

