/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.conflict;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.date.CalendarService;
import ch.cyberduck.core.date.Instant;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.synchronization.Comparison;
import ch.iterate.mountainduck.sync.conflict.ConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimestampConflictResolutionStrategy
implements ConflictResolutionStrategy {
    private static final Logger log = LogManager.getLogger((String)TimestampConflictResolutionStrategy.class.getName());
    private final MetadataService<?> metadata;

    public TimestampConflictResolutionStrategy(MetadataService<?> metadata) {
        this.metadata = metadata;
    }

    @Override
    public Comparison resolve(Local local, PathAttributes remote) {
        NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.metadata);
        if (null == dict) {
            log.error(String.format("Missing metadata for file %s", local));
            return Comparison.unknown;
        }
        PathAttributes cached = new PathAttributesDictionary().deserialize((Object)dict);
        return this.compare(local, remote, cached);
    }

    protected Comparison compare(Local local, PathAttributes remote, PathAttributes cached) {
        if (-1L == remote.getModificationDate()) {
            log.warn(String.format("Missing timestamp in remote attributes %s", remote));
            return Comparison.unknown;
        }
        if (-1L == cached.getModificationDate()) {
            log.warn(String.format("Missing timestamp in cached attributes %s", cached));
            return Comparison.unknown;
        }
        CalendarService calendar = new CalendarService(TimeZone.getTimeZone("UTC"));
        if (calendar.asDate(cached.getModificationDate(), Instant.SECOND).before(calendar.asDate(remote.getModificationDate(), Instant.SECOND))) {
            log.warn(String.format("Modification date %s in cache before %s on server for file %s", cached.getModificationDate(), remote.getModificationDate(), local));
            return Comparison.remote;
        }
        if (calendar.asDate(cached.getModificationDate(), Instant.SECOND).after(calendar.asDate(remote.getModificationDate(), Instant.SECOND))) {
            log.warn(String.format("Modification date %s in cache after %s on server for file %s", cached.getModificationDate(), remote.getModificationDate(), local));
            return Comparison.local;
        }
        return Comparison.equal;
    }
}

