/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.conflict;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.synchronization.Comparison;
import ch.iterate.mountainduck.sync.conflict.ConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RevisionConflictResolutionStrategy
implements ConflictResolutionStrategy {
    private static final Logger log = LogManager.getLogger((String)RevisionConflictResolutionStrategy.class.getName());
    private final MetadataService<?> metadata;

    public RevisionConflictResolutionStrategy(MetadataService<?> metadata) {
        this.metadata = metadata;
    }

    @Override
    public Comparison resolve(Local local, PathAttributes remote) {
        NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.metadata);
        if (null == dict) {
            log.error(String.format("Missing metadata for file %s", local));
            return Comparison.unknown;
        }
        PathAttributes cached = new PathAttributesDictionary().deserialize((Object)dict);
        return this.compare(local, remote, cached);
    }

    protected Comparison compare(Local local, PathAttributes remote, PathAttributes cached) {
        if (null != remote.getRevision() && null != cached.getRevision()) {
            if (remote.getRevision().equals(cached.getRevision())) {
                log.debug(String.format("Equal revision %s for file %s", cached.getRevision(), local));
                return Comparison.equal;
            }
            log.warn(String.format("Revision %s in cache differs from %s on server for file %s", cached.getRevision(), remote.getRevision(), local));
            return Comparison.notequal;
        }
        return Comparison.unknown;
    }
}

