/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.conflict;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.synchronization.Comparison;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.conflict.ChecksumConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.conflict.ConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.conflict.SizeConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.conflict.TimestampConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import com.dd.plist.NSDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataConflictResolutionStrategy
implements ConflictResolutionStrategy {
    private static final Logger log = LogManager.getLogger((String)MetadataConflictResolutionStrategy.class.getName());
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;

    public MetadataConflictResolutionStrategy(LocalCache<?> cache, MetadataService<?> metadata) {
        this.cache = cache;
        this.metadata = metadata;
    }

    @Override
    public Comparison resolve(Local local, PathAttributes remote) {
        if (PathAttributes.EMPTY.equals((Object)remote)) {
            log.warn(String.format("Empty remote attributes for file %s in cache", local));
            return Comparison.unknown;
        }
        switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case local: {
                log.warn(String.format("Missing remote attributes in metadata storage for file %s in cache", local));
                return Comparison.unknown;
            }
        }
        NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.metadata);
        if (null == dict) {
            log.error(String.format("Missing metadata for file %s", local));
            return Comparison.unknown;
        }
        PathAttributes cached = new PathAttributesDictionary().deserialize((Object)dict);
        switch (new ChecksumConflictResolutionStrategy(this.metadata).compare(local, remote, cached)) {
            case equal: {
                return Comparison.equal;
            }
        }
        switch (new TimestampConflictResolutionStrategy(this.metadata).compare(local, remote, cached)) {
            case remote: {
                return Comparison.remote;
            }
            case local: {
                return Comparison.local;
            }
        }
        return new SizeConflictResolutionStrategy(this.metadata).compare(local, remote, cached);
    }
}

