/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.conflict;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.synchronization.Comparison;
import ch.iterate.mountainduck.sync.conflict.ConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockIdConflictResolutionStrategy
implements ConflictResolutionStrategy {
    private static final Logger log = LogManager.getLogger((String)LockIdConflictResolutionStrategy.class.getName());
    private final MetadataService<?> metadata;

    public LockIdConflictResolutionStrategy(MetadataService<?> metadata) {
        this.metadata = metadata;
    }

    @Override
    public Comparison resolve(Local local, PathAttributes remote) {
        NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.metadata);
        if (null == dict) {
            log.error(String.format("Missing metadata for file %s", local));
            return Comparison.unknown;
        }
        PathAttributes cached = new PathAttributesDictionary().deserialize((Object)dict);
        return this.compare(local, remote, cached);
    }

    protected Comparison compare(Local local, PathAttributes remote, PathAttributes cached) {
        if (StringUtils.equals((CharSequence)remote.getLockId(), (CharSequence)cached.getLockId())) {
            return Comparison.equal;
        }
        log.warn(String.format("Lock Id %s in cache differs from %s on server for file %s", cached.getLockId(), remote.getLockId(), local));
        return Comparison.notequal;
    }
}

