/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.conflict;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.synchronization.Comparison;
import ch.iterate.mountainduck.sync.conflict.ChecksumConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.conflict.ConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.conflict.RevisionConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.conflict.TimestampConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryConflictResolutionStrategy
implements ConflictResolutionStrategy {
    private static final Logger log = LogManager.getLogger((String)DirectoryConflictResolutionStrategy.class.getName());
    private final Host bookmark;
    private final MetadataService<?> metadata;

    public DirectoryConflictResolutionStrategy(Host bookmark, MetadataService<?> metadata) {
        this.bookmark = bookmark;
        this.metadata = metadata;
    }

    @Override
    public Comparison resolve(Local local, PathAttributes remote) {
        NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.metadata);
        if (null == dict) {
            log.error(String.format("Missing metadata for file %s", local));
            return Comparison.unknown;
        }
        PathAttributes cached = new PathAttributesDictionary().deserialize((Object)dict);
        return this.compare(local, remote, cached);
    }

    protected Comparison compare(Local local, PathAttributes remote, PathAttributes cached) {
        switch (new RevisionConflictResolutionStrategy(this.metadata).compare(local, remote, cached)) {
            case notequal: {
                return Comparison.notequal;
            }
            case equal: {
                return Comparison.equal;
            }
        }
        switch (new ChecksumConflictResolutionStrategy(this.metadata).compare(local, remote, cached)) {
            case notequal: {
                return Comparison.notequal;
            }
            case equal: {
                return Comparison.equal;
            }
        }
        switch (this.bookmark.getProtocol().getDirectoryTimestamp()) {
            case explicit: {
                log.warn(String.format("Protocol %s does not allow comparison of timestamps on folders", this.bookmark.getProtocol()));
                return Comparison.remote;
            }
        }
        return new TimestampConflictResolutionStrategy(this.metadata).compare(local, remote, cached);
    }
}

