/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.conflict;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.synchronization.Comparison;
import ch.iterate.mountainduck.sync.conflict.ConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChecksumConflictResolutionStrategy
implements ConflictResolutionStrategy {
    private static final Logger log = LogManager.getLogger((String)ChecksumConflictResolutionStrategy.class.getName());
    private final MetadataService<?> metadata;

    public ChecksumConflictResolutionStrategy(MetadataService<?> metadata) {
        this.metadata = metadata;
    }

    @Override
    public Comparison resolve(Local local, PathAttributes remote) {
        NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.metadata);
        if (null == dict) {
            log.warn(String.format("No metadata for file %s", local));
            return Comparison.unknown;
        }
        PathAttributes cached = new PathAttributesDictionary().deserialize((Object)dict);
        return this.compare(local, remote, cached);
    }

    protected Comparison compare(Local local, PathAttributes remote, PathAttributes cached) {
        if (!Checksum.NONE.equals((Object)remote.getChecksum()) && !Checksum.NONE.equals((Object)cached.getChecksum())) {
            if (remote.getChecksum().equals((Object)cached.getChecksum())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Equal checksum %s for file %s", cached.getChecksum(), local));
                }
                return Comparison.equal;
            }
            log.warn(String.format("Checksum %s in cache differs from %s on server for file %s", cached.getChecksum(), remote.getChecksum(), local));
            return Comparison.notequal;
        }
        if (null != remote.getVersionId() && null != cached.getVersionId()) {
            if (StringUtils.equals((String)remote.getVersionId(), (String)cached.getVersionId())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Equal versionId %s for file %s", cached.getVersionId(), local));
                }
                return Comparison.equal;
            }
            log.warn(String.format("Version Id %s in cache differs from %s on server for file %s", cached.getVersionId(), remote.getVersionId(), local));
            return Comparison.notequal;
        }
        if (null != remote.getETag() && null != cached.getETag()) {
            if (remote.getETag().equals(cached.getETag())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Equal ETag %s for file %s", cached.getETag(), local));
                }
                return Comparison.equal;
            }
            log.warn(String.format("ETag %s in cache differs from %s on server for file %s", cached.getETag(), remote.getETag(), local));
            return Comparison.notequal;
        }
        if (null != remote.getRevision() && null != cached.getRevision()) {
            if (remote.getRevision().equals(cached.getRevision())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Equal revision %s for file %s", cached.getRevision(), local));
                }
                return Comparison.equal;
            }
            log.warn(String.format("Revision %s in cache differs from %s on server for file %s", cached.getRevision(), remote.getRevision(), local));
            return Comparison.notequal;
        }
        return Comparison.unknown;
    }
}

