/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.cache.cryptomator;

import ch.iterate.mountainduck.sync.cache.cryptomator.ByteSource;
import java.nio.ByteBuffer;

public class ZeroPrefixedByteSource
implements ByteSource {
    private long amountOfZeroes;
    private final ByteBuffer source;

    public ZeroPrefixedByteSource(long amountOfZeroes, ByteBuffer source) {
        this.amountOfZeroes = amountOfZeroes;
        this.source = source;
    }

    @Override
    public boolean hasRemaining() {
        return this.amountOfZeroes > 0L || this.source.hasRemaining();
    }

    @Override
    public long remaining() {
        return this.amountOfZeroes + (long)this.source.remaining();
    }

    @Override
    public void copyTo(ByteBuffer target) {
        if (this.amountOfZeroes > 0L) {
            this.copyZeroesTo(target);
        }
        if (target.hasRemaining()) {
            this.copySourceTo(target);
        }
    }

    private void copyZeroesTo(ByteBuffer target) {
        int amountOfZeroesAsInt = (int)Math.min(this.amountOfZeroes, Integer.MAX_VALUE);
        int amountOfZeroesToCopy = Math.min(amountOfZeroesAsInt, target.remaining());
        ByteBuffer zeroes = ByteBuffer.allocate(amountOfZeroesToCopy);
        target.put(zeroes);
        this.amountOfZeroes -= (long)amountOfZeroesToCopy;
    }

    private void copySourceTo(ByteBuffer target) {
        int originalLimit = this.source.limit();
        int limit = Math.min(this.source.limit(), this.source.position() + target.remaining());
        this.source.limit(limit);
        target.put(this.source);
        this.source.limit(originalLimit);
    }
}

