/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.cache.cryptomator;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.cryptomator.CryptoAuthenticationException;
import ch.cyberduck.core.cryptomator.CryptoDirectory;
import ch.cyberduck.core.cryptomator.CryptoFilename;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV6Provider;
import ch.cyberduck.core.cryptomator.impl.CryptoFilenameV6Provider;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.local.DefaultSymlinkFeature;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.local.features.Trash;
import ch.cyberduck.core.nio.LocalFindFeature;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultCredentials;
import ch.cyberduck.core.vault.VaultException;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.sync.cache.FileChannelLocalCache;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cryptomator.cryptolib.common.MasterkeyFile;

public class ObfuscatingLocalCache<Inode>
extends FileChannelLocalCache<Inode>
implements VaultRegistry {
    private static final Logger log = LogManager.getLogger((String)ObfuscatingLocalCache.class.getName());
    private static final Path NOTFOUND_MARKER = new Path(UUID.randomUUID().toString(), EnumSet.noneOf(AbstractPath.Type.class));
    private final LRUCache<FilesystemCacheReference, Path> lookup = LRUCache.build((long)PreferencesFactory.get().getLong("fs.sync.metadata.cache.size"));
    private final HostPasswordStore keychain = PasswordStoreFactory.get();
    private final Trash trash = LocalTrashFactory.get();
    private final CryptoVault vault;
    private final Local directory;
    private final MetadataService<?> metadata;
    private final Host bookmark;
    private final int threshold;

    public ObfuscatingLocalCache(Controller controller, Host bookmark, Local directory, FileidMapper<Inode> fileid, MetadataService<?> metadata) {
        super(controller, bookmark, directory, fileid, metadata);
        this.bookmark = bookmark;
        this.directory = directory;
        this.metadata = metadata;
        if (directory.exists()) {
            NSDictionary dict = metadata.read(directory, MetadataStorage.Key.shortening);
            if (null == dict) {
                log.warn(String.format("Missing key %s for cache %s", MetadataStorage.Key.shortening, directory));
                this.threshold = 130;
            } else {
                this.threshold = Integer.parseInt(dict.objectForKey("Threshold").toString());
            }
        } else {
            this.threshold = ObfuscatingLocalCache.determineShorteningThreshold(directory);
        }
        final Path home = new Path(StringUtils.replace((String)this.getDirectory().getAbsolute(), (String)String.valueOf(this.getDirectory().getDelimiter()), (String)String.valueOf('/')), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.vault));
        this.vault = new CryptoVault(home){

            public long toCiphertextSize(long cleartextFileOffset, long cleartextFileSize) {
                return cleartextFileSize;
            }

            public long toCleartextSize(long cleartextFileOffset, long ciphertextFileSize) {
                return ciphertextFileSize;
            }

            protected void open(MasterkeyFile mkFile, CharSequence passphrase) throws VaultException, CryptoAuthenticationException {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Open cache %s with path length shortening threshold %d", home, ObfuscatingLocalCache.this.threshold));
                }
                this.open(mkFile, passphrase, (CryptoFilename)new CryptoFilenameV6Provider(home, ObfuscatingLocalCache.this.threshold), (CryptoDirectory)new CryptoDirectoryV6Provider(home, (CryptoVault)this));
            }
        };
        this.session.withRegistry((VaultRegistry)this);
    }

    @Override
    protected void create(Path workdir, Local directory) throws BackgroundException {
        if (!directory.getParent().exists()) {
            new DefaultLocalDirectoryFeature().mkdir(directory.getParent());
        }
        if (!new LocalFindFeature(this.session).find(this.vault.getMasterkey())) {
            this.vault.create((Session)this.session, new VaultCredentials(new UUIDRandomStringService().random()).withSaved(true), (PasswordStore)this.keychain, PreferencesFactory.get().getInteger("fs.sync.cache.vault.version"));
            this.metadata.write(directory, MetadataStorage.Key.placeholder, new NSDictionary());
        }
        try {
            if (log.isInfoEnabled()) {
                log.info(String.format("Unlock vault in %s", directory));
            }
            this.vault.load((Session)this.session, (PasswordCallback)new DisabledLoginCallback(), (PasswordStore)this.keychain);
        }
        catch (AccessDeniedException | LoginCanceledException | LoginFailureException e) {
            log.warn(String.format("Failure to unlock cache %s. %s", directory, e.getMessage()));
            if (directory.exists()) {
                log.warn(String.format("Trash cache directory %s", directory));
                this.trash.trash(directory);
            }
            log.info(String.format("Retry opening cache from %s", directory));
            this.create(workdir, directory);
            return;
        }
        super.create(workdir, directory);
    }

    public static int determineShorteningThreshold(Local directory) {
        if (PreferencesFactory.get().getBoolean("fs.sync.cache.longpaths.enabled")) {
            if (log.isDebugEnabled()) {
                log.debug("Long path name support is enabled");
            }
            return 130;
        }
        int MAX_PATH_WINDOWS = 259;
        int LENGTH_PATH_IN_VAULT = 168;
        return Math.min(130, 130 + (259 - directory.getAbsolute().length() - 168));
    }

    @Override
    public LocalCache<Inode> open(Path workdir, Local mountpoint) throws BackgroundException {
        super.open(workdir, mountpoint);
        NSDictionary shortening = new NSDictionary();
        shortening.put("Threshold", (Object)this.threshold);
        this.metadata.write(this.directory, MetadataStorage.Key.shortening, shortening);
        return this;
    }

    private void evict(Path ... files) {
        for (Path file : files) {
            this.lookup.asMap().keySet().stream().filter(reference -> reference.equals((Object)new FilesystemCacheReference(new Path(file.getParent(), file.getName(), EnumSet.noneOf(AbstractPath.Type.class)))) || reference.getFile().isChild(file)).forEach(arg_0 -> this.lookup.remove(arg_0));
        }
    }

    private Path lookup(FilesystemCacheReference reference) throws BackgroundException {
        Path file;
        String filename;
        Path directory = reference.getFile().getParent();
        if (this.loadLocal(new FilesystemCacheReference(new Path(directory, filename = reference.getFile().getName(), EnumSet.of(AbstractPath.Type.file)))).exists()) {
            file = new Path(directory, filename, EnumSet.of(AbstractPath.Type.file));
        } else if (this.loadLocal(new FilesystemCacheReference(new Path(directory, filename, EnumSet.of(AbstractPath.Type.directory)))).exists()) {
            file = new Path(directory, filename, EnumSet.of(AbstractPath.Type.directory));
        } else {
            switch (this.bookmark.getProtocol().getCaseSensitivity()) {
                case insensitive: {
                    Path file2 = this.search(directory, filename);
                    if (null == file2) {
                        throw new NotfoundException(filename);
                    }
                    return file2;
                }
            }
            throw new NotfoundException(filename);
        }
        Local local = this.loadLocal(new FilesystemCacheReference(file));
        if (!local.exists()) {
            throw new NotfoundException(filename);
        }
        Path remote = new Path(directory, file.getName(), this.type(local), this.getattr(local));
        if (local.isSymbolicLink()) {
            remote.setSymlinkTarget(this.readlink(local));
        }
        return remote;
    }

    @Override
    public Path find(Path directory, String filename, FilesystemCallbacks.Flags flags) throws BackgroundException {
        FilesystemCacheReference ref = new FilesystemCacheReference(new Path(directory, filename, EnumSet.noneOf(AbstractPath.Type.class)));
        Path cached = (Path)this.lookup.get((Object)ref);
        if (null == cached) {
            try {
                Path f = this.lookup(ref);
                this.lookup.put((Object)ref, (Object)f);
                return f;
            }
            catch (NotfoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Cache %s as not found", filename));
                }
                this.lookup.put((Object)ref, (Object)NOTFOUND_MARKER);
                throw new NotfoundException(filename);
            }
        }
        if (cached == NOTFOUND_MARKER) {
            throw new NotfoundException(filename);
        }
        return cached;
    }

    @Override
    public void placeholder(Path file, PathAttributes attributes) throws BackgroundException {
        super.placeholder(file, attributes);
        this.evict(file);
    }

    @Override
    public Inode touch(Path file) throws BackgroundException {
        Object Inode;
        try {
            Inode = super.touch(file);
        }
        catch (Throwable throwable) {
            this.evict(file);
            throw throwable;
        }
        this.evict(file);
        return Inode;
    }

    @Override
    public EnumSet<AbstractPath.Type> type(Local local) {
        NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.type);
        if (null == dict) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Missing type information in metadata storage for file %s", local));
            }
            if (local.isChild(this.getDirectory())) {
                return EnumSet.of(local.getName().startsWith("0") ? AbstractPath.Type.directory : AbstractPath.Type.file);
            }
        }
        return super.type(local);
    }

    @Override
    public void setattr(Path file, EnumSet<AbstractPath.Type> filetype, PathAttributes attributes, boolean prune) {
        super.setattr(file, filetype, attributes, prune);
        if (file.isSymbolicLink() && PreferencesFactory.get().getBoolean("fs.symlink.enable")) {
            NSDictionary dict = new NSDictionary();
            dict.put("Path", (NSObject)file.getSymlinkTarget().serialize(SerializerFactory.get()));
            dict.put("Attributes", (NSObject)file.getSymlinkTarget().attributes().serialize(SerializerFactory.get()));
            this.metadata.write(this.toLocal(file), MetadataStorage.Key.symlinktarget, dict);
        }
        this.evict(file);
    }

    private Path readlink(Local local) {
        NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.symlinktarget);
        if (null == dict) {
            log.warn(String.format("Missing metadata for symbolic link target of %s", local));
            return null;
        }
        return new PathDictionary().deserialize((Object)dict.objectForKey("Path")).withAttributes(new PathAttributesDictionary().deserialize((Object)dict.objectForKey("Attributes")));
    }

    @Override
    protected Path _symlink(Path file, Path target) throws AccessDeniedException {
        Local local = this.toLocal(file);
        new DefaultSymlinkFeature().symlink(local, this.toLocal(target).getAbsolute());
        NSDictionary dict = new NSDictionary();
        dict.put("Path", (NSObject)target.serialize(SerializerFactory.get()));
        dict.put("Attributes", (NSObject)target.attributes().serialize(SerializerFactory.get()));
        this.metadata.write(local, MetadataStorage.Key.symlinktarget, dict);
        NSDictionary type = new NSDictionary();
        type.put("Type", (Object)String.valueOf(EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.symboliclink)));
        this.metadata.write(local, MetadataStorage.Key.type, type);
        return file;
    }

    @Override
    public Path toRemote(Path file) {
        Path remote = super.toRemote(file);
        if (remote.isSymbolicLink()) {
            remote.setSymlinkTarget(this.readlink(this.toLocal(remote)));
        }
        return remote;
    }

    @Override
    protected Local loadLocal(FilesystemCacheReference file) {
        Path encrypted;
        Path internal = this.toInternal(file.getFile());
        try {
            encrypted = this.vault.encrypt((Session)this.session, internal, internal.isDirectory());
            if (log.isDebugEnabled()) {
                log.debug(String.format("Encrypted %s to %s", file.getFile(), encrypted));
            }
        }
        catch (BackgroundException e) {
            throw new RuntimeException(String.format("Failure %s encrypting path to local cache", new Object[]{e}));
        }
        return LocalFactory.get((String)encrypted.getAbsolute());
    }

    public Vault find(Session session, Path file) {
        return this.vault;
    }

    public boolean add(Vault vault) {
        return false;
    }

    public boolean close(Path vault) {
        return false;
    }

    public void clear() {
    }

    public <T> T getFeature(Session<?> session, Class<T> type, T proxy) {
        if (null == proxy) {
            return null;
        }
        if (type == Touch.class) {
            return (T)session._getFeature(type);
        }
        if (type == Read.class) {
            return (T)session._getFeature(type);
        }
        if (type == Write.class) {
            return (T)session._getFeature(type);
        }
        return (T)this.vault.getFeature(session, type, proxy);
    }

    public boolean contains(Path vault) {
        return this.vault.contains(vault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(Path file, byte[] chunk, int count, long offset) throws BackgroundException {
        int n;
        try {
            n = super.write(file, chunk, count, offset);
        }
        catch (Throwable throwable) {
            this.evict(file);
            throw throwable;
        }
        this.evict(file);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferStatus close(Path file, FilesystemCallbacks.Mode flags, Application application, boolean releaseLock) throws BackgroundException {
        TransferStatus transferStatus;
        try {
            transferStatus = super.close(file, flags, application, releaseLock);
        }
        catch (Throwable throwable) {
            this.evict(file);
            throw throwable;
        }
        this.evict(file);
        return transferStatus;
    }

    @Override
    public Inode mkdir(Path directory) throws BackgroundException {
        Object Inode;
        try {
            Inode = super.mkdir(directory);
        }
        catch (Throwable throwable) {
            this.evict(directory);
            throw throwable;
        }
        this.evict(directory);
        return Inode;
    }

    @Override
    public void truncate(Path file, long size) throws BackgroundException {
        super.truncate(file, size);
        this.evict(file);
    }

    @Override
    public Set<Path> delete(Path file) throws BackgroundException {
        Set<Path> result = super.delete(file);
        for (Path f : result) {
            if (!f.isDirectory()) continue;
            this.vault.getDirectoryProvider().delete(this.toInternal(file));
        }
        this.evict(file);
        return result;
    }

    @Override
    public Set<Path> trash(Path file) throws BackgroundException {
        Set<Path> purged = super.trash(file);
        for (Path f : purged) {
            if (!f.isDirectory()) continue;
            this.vault.getDirectoryProvider().delete(this.toInternal(f));
        }
        this.evict(purged.toArray(new Path[0]));
        return purged;
    }

    @Override
    public Map<Path, Path> rename(Path file, Path target) throws BackgroundException {
        Map<Path, Path> result = super.rename(file, target);
        for (Map.Entry<Path, Path> entry : result.entrySet()) {
            if (entry.getKey().isDirectory()) {
                this.vault.getDirectoryProvider().delete(this.toInternal(entry.getKey()));
            }
            if (!entry.getValue().isDirectory()) continue;
            this.vault.getDirectoryProvider().delete(this.toInternal(entry.getValue()));
        }
        this.evict(result.keySet().toArray(new Path[0]));
        this.evict(result.values().toArray(new Path[0]));
        return result;
    }

    @Override
    public void invalidate(Path file) {
        this.evict(file);
        if (file.isDirectory()) {
            this.vault.getDirectoryProvider().delete(this.toInternal(file));
        }
        super.invalidate(file);
    }

    @Override
    public void close() throws BackgroundException {
        super.close();
        this.vault.close();
    }

    @Override
    public Long getSize() {
        return 0L;
    }

    @Override
    public LocalCache.Version version() {
        return new LocalCache.Version(LocalCache.Type.encrypted, 4);
    }
}

