/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.cache.cryptomator;

import ch.iterate.mountainduck.sync.cache.cryptomator.ByteSource;
import java.nio.ByteBuffer;

public class ChunkData {
    private final ByteBuffer bytes;
    private boolean written;
    private int length;

    public static ChunkData wrap(ByteBuffer bytes) {
        return new ChunkData(bytes, bytes.limit());
    }

    public static ChunkData emptyWithSize(int size) {
        return new ChunkData(ByteBuffer.allocate(size), 0);
    }

    private ChunkData(ByteBuffer bytes, int length) {
        this.bytes = bytes;
        this.written = false;
        this.length = length;
    }

    public void truncate(int length) {
        if (this.length > length) {
            this.length = length;
            this.written = true;
        }
    }

    public CopyWithoutDirection copyDataStartingAt(final int offset) {
        return new CopyWithoutDirection(){

            @Override
            public void to(ByteBuffer target) {
                ChunkData.this.bytes.limit(Math.min(ChunkData.this.length, target.remaining() + offset));
                ChunkData.this.bytes.position(offset);
                target.put(ChunkData.this.bytes);
            }

            @Override
            public void from(ByteSource source) {
                ChunkData.this.written = true;
                ChunkData.this.bytes.limit(ChunkData.this.bytes.capacity());
                ChunkData.this.bytes.position(offset);
                source.copyTo(ChunkData.this.bytes);
                ChunkData.this.length = Math.max(ChunkData.this.length, ChunkData.this.bytes.position());
            }
        };
    }

    public int getLength() {
        return this.length;
    }

    public byte[] asBytes() {
        ByteBuffer buffer = this.bytes.asReadOnlyBuffer();
        buffer.flip();
        buffer.limit(this.length);
        byte[] b = new byte[this.length];
        buffer.get(b, 0, b.length);
        return b;
    }

    public String toString() {
        return String.format("ChunkData(written: %s, length: %d, capacity: %d)", this.written, this.length, this.bytes.capacity());
    }

    public static interface CopyWithoutDirection {
        public void to(ByteBuffer var1);

        public void from(ByteSource var1);
    }
}

