/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.cache;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.IOResumeException;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.local.DefaultLocalTouchFeature;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.local.features.Trash;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.threading.DisabledAlertCallback;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.CreateDirectoryWorker;
import ch.cyberduck.core.worker.CreateSymlinkWorker;
import ch.cyberduck.core.worker.DeleteWorker;
import ch.cyberduck.core.worker.MoveWorker;
import ch.cyberduck.core.worker.SessionListWorker;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.exception.DirectoryNotEmptyException;
import ch.iterate.mountainduck.exception.FilesystemIOExceptionMappingService;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemIncrementalListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.cache.LocalCacheListProgressListener;
import ch.iterate.mountainduck.sync.cache.MetadataLocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.threading.BlockingWorkerExecutor;
import ch.iterate.mountainduck.threading.WorkerExecutor;
import com.dd.plist.NSDictionary;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SessionLocalCache<Inode>
extends MetadataLocalCache<Inode> {
    private static final Logger log = LogManager.getLogger((String)SessionLocalCache.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final Trash trash = LocalTrashFactory.get();
    protected final WorkerExecutor executor;
    protected final LocalSession session;
    private final Host bookmark;
    private final FileidMapper<Inode> fileid;
    private final MetadataService<?> metadata;

    public SessionLocalCache(Controller controller, Host bookmark, Local directory, FileidMapper<Inode> fileid, MetadataService<?> metadata) {
        super(directory, metadata, fileid);
        this.bookmark = bookmark;
        this.fileid = fileid;
        this.metadata = metadata;
        this.session = new LocalSession(new Host((Protocol)new LocalProtocol()).withCredentials(new Credentials(System.getProperty("user.name"))));
        this.executor = new BlockingWorkerExecutor(controller, this.session.getHost(), (AlertCallback)new DisabledAlertCallback(), BackgroundActionRegistry.global());
    }

    @Override
    public LocalCache<Inode> open(Path workdir, Local mountpoint) throws BackgroundException {
        this.session.open(Proxy.DIRECT, (HostKeyCallback)new DisabledHostKeyCallback(), (LoginCallback)new DisabledLoginCallback(), (CancelCallback)new DisabledCancelCallback());
        return super.open(workdir, mountpoint);
    }

    @Override
    public void close() throws BackgroundException {
        log.warn(String.format("Closing cache %s", this));
        this.session.close();
    }

    @Override
    public LocalCache.State getState() {
        switch (super.getState()) {
            case open: {
                return this.session.isConnected() ? LocalCache.State.open : LocalCache.State.closed;
            }
        }
        return LocalCache.State.closed;
    }

    public Path find(Path directory, String filename, FilesystemCallbacks.Flags flags) throws BackgroundException {
        if (StringUtils.equals((CharSequence)String.valueOf('/'), (CharSequence)filename)) {
            return directory;
        }
        Local local = this.loadLocal(new FilesystemCacheReference(new Path(directory, filename, EnumSet.of(AbstractPath.Type.file))));
        if (!local.exists()) {
            throw new NotfoundException(filename);
        }
        return this.toRemote(local);
    }

    private Path toRemote(Local file) {
        String path = StringUtils.replace((String)file.getAbsolute(), (String)String.valueOf(file.getDelimiter()), (String)String.valueOf('/'));
        Path internal = new Path(path, this.type(file), this.getattr(file));
        if (internal.isSymbolicLink()) {
            try {
                internal.setSymlinkTarget(this.toRemote(file.getSymlinkTarget()));
            }
            catch (NotfoundException e) {
                log.warn(String.format("Failure resolving symbolic link target for %s", file));
            }
        }
        return this.toRemote(internal);
    }

    @Override
    public Map<Path, Path> rename(Path file, Path target) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Rename file %s to %s", file, target));
        }
        this.metadata.flush(this.toLocal(file));
        NSDictionary previous = this.metadata.read(this.toLocal(target), MetadataStorage.Key.metadata);
        if (previous != null) {
            log.warn(String.format("Apply previous metadata %s of %s to %s", previous, target, file));
            this.metadata.write(this.toLocal(target), MetadataStorage.Key.metadata, previous);
        } else {
            this.metadata.delete(this.toLocal(target), MetadataStorage.Key.metadata);
        }
        this.metadata.flush(this.toLocal(file));
        Map result = new MoveWorker(Collections.singletonMap(this.toInternal(file), this.toInternal(target)), (SessionPool)new SessionPool.SingleSessionPool((Session)this.session), (Cache)PathCache.empty(), (ProgressListener)new DisabledProgressListener(), (ConnectionCallback)new DisabledConnectionCallback()).run((Session)this.session);
        for (Map.Entry entry : result.entrySet()) {
            this.fileid.swap(this.toRemote((Path)entry.getKey()), this.toRemote((Path)entry.getValue()));
        }
        return super.rename(file, target);
    }

    @Override
    public Set<Path> delete(Path file) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Delete file %s", file));
        }
        Path internal = this.toInternal(file);
        Local local = this.toLocal(file);
        if (file.isDirectory() && !file.isSymbolicLink() && !((ListService)this.session.getFeature(ListService.class)).list(internal, (ListProgressListener)new DisabledListProgressListener()).isEmpty()) {
            throw new DirectoryNotEmptyException(file.getAbsolute());
        }
        super.delete(file);
        return new HashSet<Path>(new DeleteWorker((LoginCallback)new DisabledLoginCallback(), Collections.singletonList(internal), (ProgressListener)new DisabledProgressListener()).run((Session)this.session));
    }

    @Override
    public Set<Path> trash(Path file) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Trash file %s", file));
        }
        Set<Path> trashed = super.trash(file);
        if (this.preferences.getBoolean("fs.sync.cache.trash")) {
            try {
                this.trash.trash(this.toLocal(file));
            }
            catch (AccessDeniedException e) {
                log.warn(String.format("Failure %s trashing %s in cache ", new Object[]{e, file}));
            }
        } else {
            try {
                new DeleteWorker((LoginCallback)new DisabledLoginCallback(), Collections.singletonList(this.toInternal(file)), (ProgressListener)new DisabledProgressListener()).run((Session)this.session);
            }
            catch (BackgroundException e) {
                log.warn(String.format("Failure %s deleting %s in cache", new Object[]{e, file}));
            }
        }
        return trashed;
    }

    public void placeholder(Path file, PathAttributes attributes) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add placeholder for file %s", file));
        }
        if (file.isSymbolicLink() && this.preferences.getBoolean("fs.symlink.enable")) {
            this.symlink(file, file.getSymlinkTarget());
        } else if (file.isDirectory()) {
            this.mkdir(file);
        } else {
            this.touch(file);
        }
        this.metadata.write(this.toLocal(file), MetadataStorage.Key.placeholder, new NSDictionary());
        this.setattr(file, file.getType(), attributes, true);
    }

    public Inode mkdir(Path directory) throws BackgroundException {
        this.metadata.purge(this.toLocal(directory));
        this.localCache.remove((Object)new FilesystemCacheReference(directory));
        return (Inode)this.fileid.getOrCreate(this.toRemote(this._mkdir(directory)));
    }

    protected Path _mkdir(Path directory) throws BackgroundException {
        Path result = new CreateDirectoryWorker(this.toInternal(directory), null).run((Session)this.session);
        NSDictionary type = new NSDictionary();
        type.put("Type", (Object)String.valueOf(EnumSet.of(AbstractPath.Type.directory)));
        this.metadata.write(this.toLocal(directory), MetadataStorage.Key.type, type);
        return result;
    }

    public Inode touch(Path file) throws BackgroundException {
        Local local = this.toLocal(file);
        this.metadata.purge(local);
        this.localCache.remove((Object)new FilesystemCacheReference(file));
        return (Inode)this.fileid.getOrCreate(this.toRemote(this._touch(file)));
    }

    protected Path _touch(Path file) throws BackgroundException {
        new DefaultLocalTouchFeature().touch(this.toLocal(file));
        NSDictionary type = new NSDictionary();
        type.put("Type", (Object)String.valueOf(EnumSet.of(AbstractPath.Type.file)));
        this.metadata.write(this.toLocal(file), MetadataStorage.Key.type, type);
        return file;
    }

    public Inode symlink(Path file, Path target) throws BackgroundException {
        this.localCache.remove((Object)new FilesystemCacheReference(file));
        return (Inode)this.fileid.getOrCreate(this.toRemote(this._symlink(file, target)));
    }

    protected Path _symlink(Path file, Path target) throws BackgroundException {
        Path result = new CreateSymlinkWorker(this.toInternal(file), this.toLocal(target).getAbsolute()).run((Session)this.session);
        NSDictionary type = new NSDictionary();
        type.put("Type", (Object)String.valueOf(EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.symboliclink)));
        this.metadata.write(this.toLocal(file), MetadataStorage.Key.type, type);
        return result;
    }

    public Path search(Path directory, String filename) throws BackgroundException {
        final FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(this.bookmark, (ProgressListener)new DisabledProgressListener());
        SessionListWorker worker = new SessionListWorker((Cache)PathCache.empty(), this.toInternal(directory), (ListProgressListener)listener){

            public void cleanup(AttributedList<Path> list) {
                listener.finish();
                super.cleanup(list);
            }
        };
        this.executor.run((Worker)worker, (SessionPool)new SessionPool.SingleSessionPool((Session)this.session));
        return this.toRemote(listener.search(filename));
    }

    public Worker<AttributedList<Path>> list(Path directory, final FilesystemListProgressListener listener, long fromCookie) throws BackgroundException {
        SessionListWorker worker = new SessionListWorker((Cache)PathCache.empty(), this.toInternal(directory), (ListProgressListener)new LocalCacheListProgressListener(this, directory, listener)){

            public AttributedList<Path> run(Session<?> session) throws BackgroundException {
                try {
                    return super.run(session);
                }
                catch (BackgroundException e) {
                    listener.error(e);
                    throw e;
                }
            }

            public void cleanup(AttributedList<Path> list) {
                listener.finish();
                super.cleanup(list);
            }
        };
        this.executor.run((Worker)worker, (SessionPool)new SessionPool.SingleSessionPool((Session)this.session));
        return worker;
    }

    public int read(Path file, byte[] chunk, long offset, int count) throws BackgroundException {
        int n;
        block14: {
            Read feature = (Read)this.session.getFeature(Read.class);
            TransferStatus status = new TransferStatus().exists(this.toLocal(file).exists()).withLength(-1L);
            if (offset > 0L && feature.offset(file)) {
                status.append(true).withOffset(offset);
            }
            InputStream stream = feature.read(this.toInternal(file), status, (ConnectionCallback)new DisabledConnectionCallback());
            try {
                if (offset > 0L && !status.isAppend()) {
                    try {
                        long n2;
                        long remaining = offset;
                        while (remaining > 0L && (n2 = stream.skip(remaining)) > 0L) {
                            if ((remaining -= n2) >= offset) continue;
                            log.warn(String.format("Skipped %d bytes instead of %d", n2, offset));
                        }
                        if (remaining > 0L) {
                            throw new IOResumeException(String.format("Failed to skip %d bytes of %d", remaining, offset));
                        }
                    }
                    catch (IOException e) {
                        throw new DefaultIOExceptionMappingService().map(e);
                    }
                }
                n = FilesystemCallbacks.read((InputStream)stream, (byte[])chunk, (int)0, (int)count);
                if (stream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
            }
            stream.close();
        }
        return n;
    }

    public int write(Path file, byte[] chunk, int count, long offset) throws BackgroundException {
        int n;
        block9: {
            Write feature = (Write)this.session.getFeature(Write.class);
            Local local = this.toLocal(file);
            TransferStatus status = new TransferStatus().exists(local.exists()).withLength((long)count);
            if (offset > 0L) {
                status.append(true).withOffset(offset);
            }
            StatusOutputStream stream = feature.write(this.toInternal(file), status, (ConnectionCallback)new DisabledConnectionCallback());
            try {
                IOUtils.write((byte[])Arrays.copyOf(chunk, count), (OutputStream)stream);
                n = count;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FilesystemIOExceptionMappingService().map(e);
                }
            }
            stream.close();
        }
        return n;
    }
}

