/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.cache;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalAttributes;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.local.features.Trash;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.cyberduck.core.serializer.PermissionDictionary;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemIncrementalListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.fs.buffer.NullBuffer;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MetadataLocalCache<Inode>
implements LocalCache<Inode> {
    private static final Logger log = LogManager.getLogger((String)MetadataLocalCache.class.getName());
    private final Trash trash = LocalTrashFactory.get();
    private final Preferences preferences = PreferencesFactory.get();
    private final Local directory;
    private final FileidMapper<Inode> fileid;
    private final MetadataService<?> metadata;
    protected final LRUCache<FilesystemCacheReference, Local> localCache = LRUCache.usingLoader(this::loadLocal, (long)PreferencesFactory.get().getLong("fs.sync.metadata.cache.size"));
    private final PlaceholderStatusService placeholderStatusService;
    private final Local directoryWithVersion;
    private final ch.cyberduck.core.Path rootWithVersion;
    private ch.cyberduck.core.Path workdir;
    private Local volume;

    public MetadataLocalCache(Local directory, MetadataService<?> metadata, FileidMapper<Inode> fileid) {
        this.directory = directory;
        if (directory.exists()) {
            NSDictionary dict = metadata.read(directory, MetadataStorage.Key.version);
            LocalCache.Version version = null == dict ? new LocalCache.Version(LocalCache.Type.cleartext, 1) : new LocalCache.Version(LocalCache.Type.valueOf((String)dict.objectForKey("Type").toString()), Integer.parseInt(dict.objectForKey("Version").toString()));
            if (!this.version().equals((Object)version)) {
                log.warn(String.format("Incompatible cache version %s in %s", dict, directory));
                try {
                    this.trash.trash(directory);
                }
                catch (AccessDeniedException e) {
                    log.warn(String.format("Failure trashing cache directory %s. %s", new Object[]{directory, e}));
                }
            }
        }
        this.directoryWithVersion = LocalFactory.get((Local)directory, (String)String.valueOf(this.version().version));
        this.rootWithVersion = new ch.cyberduck.core.Path(StringUtils.replace((String)this.directoryWithVersion.getAbsolute(), (String)"\\", (String)"/"), EnumSet.of(AbstractPath.Type.directory));
        this.metadata = metadata;
        this.fileid = fileid;
        this.placeholderStatusService = new PlaceholderStatusService(this, metadata);
    }

    public Local getDirectory() {
        return this.directoryWithVersion;
    }

    public Long getSize() {
        try {
            return Files.walk(Paths.get(this.directoryWithVersion.getAbsolute(), new String[0]), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).mapToLong(File::length).sum();
        }
        catch (IOException e) {
            log.error(String.format("Error obtaining cache size for %s. %s", this.directoryWithVersion, e.getMessage()));
            return 0L;
        }
    }

    public LocalCache<Inode> open(ch.cyberduck.core.Path workdir, Local volume) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open cache from %s", this.directoryWithVersion));
        }
        this.workdir = workdir;
        this.volume = volume;
        this.create(workdir, this.directoryWithVersion);
        NSDictionary version = new NSDictionary();
        version.put("Type", (Object)this.version().type.name());
        version.put("Version", (Object)String.valueOf(this.version().version));
        this.metadata.write(this.directory, MetadataStorage.Key.version, version);
        workdir.setType(this.type(workdir));
        workdir.setAttributes(this.getattr(this.toLocal(workdir)));
        return this;
    }

    protected void create(ch.cyberduck.core.Path workdir, Local directory) throws BackgroundException {
        if (!directory.getParent().exists()) {
            new DefaultLocalDirectoryFeature().mkdir(directory.getParent());
        }
        ch.cyberduck.core.Path p = workdir;
        ArrayList<ch.cyberduck.core.Path> intermediates = new ArrayList<ch.cyberduck.core.Path>();
        intermediates.add(0, p);
        while (p.isChild(this.toRemote(this.rootWithVersion))) {
            p = p.getParent();
            intermediates.add(0, p);
        }
        for (ch.cyberduck.core.Path d : intermediates) {
            Local local = this.toLocal(d);
            if (!local.exists(new LinkOption[0])) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Create missing directory %s in cache with attributes %s", local, d.attributes()));
                }
                this.placeholder(d, d.attributes());
                continue;
            }
            if (PathAttributes.EMPTY.equals((Object)d.attributes())) continue;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Set attributes %s for directory %s in cache", d.attributes(), local));
            }
            this.setattr(d, d.getType(), d.attributes());
        }
    }

    public abstract void close() throws BackgroundException;

    public LocalCache.State getState() {
        return null == this.workdir ? LocalCache.State.closed : LocalCache.State.open;
    }

    public Local toMount(ch.cyberduck.core.Path file) {
        switch (this.getState()) {
            case closed: {
                return this.directory;
            }
        }
        if (new SimplePathPredicate(this.workdir).test(file)) {
            return MetadataLocalCache.normalize(this.volume.getAbsolute(), "", CharUtils.toChar((String)PreferencesFactory.get().getProperty("local.delimiter")));
        }
        String relative = PathRelativizer.relativize((String)this.workdir.getAbsolute(), (String)file.getAbsolute()).replace('/', file.getDelimiter());
        return MetadataLocalCache.normalize(this.volume.getAbsolute(), relative, CharUtils.toChar((String)PreferencesFactory.get().getProperty("local.delimiter")));
    }

    protected static Local normalize(String volume, String file, char delimiter) {
        String mount = FilenameUtils.normalizeNoEndSeparator((String)volume, ('/' == delimiter ? 1 : 0) != 0);
        return LocalFactory.get((String)String.format("%s%s%s", mount, StringUtils.endsWith((CharSequence)mount, (CharSequence)String.valueOf(delimiter)) ? "" : Character.valueOf(delimiter), file));
    }

    public Local toLocal(ch.cyberduck.core.Path file, boolean resolve) {
        return (Local)this.localCache.get((Object)new FilesystemCacheReference(resolve ? this.resolve(file) : file));
    }

    public long toCiphertextSize(long cleartextFileSize) {
        return cleartextFileSize;
    }

    public long toCleartextSize(long ciphertextFileSize) {
        return ciphertextFileSize;
    }

    protected Local loadLocal(FilesystemCacheReference file) {
        return LocalFactory.get((String)this.toInternal(file.getFile()).getAbsolute());
    }

    public ch.cyberduck.core.Path toRemote(ch.cyberduck.core.Path file) {
        ch.cyberduck.core.Path remote;
        String stripped;
        String path = file.getAbsolute();
        if (path.equals(stripped = StringUtils.removeStart((String)path, (String)this.rootWithVersion.getAbsolute()))) {
            return file;
        }
        if (StringUtils.isBlank((CharSequence)stripped)) {
            return new ch.cyberduck.core.Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume));
        }
        ch.cyberduck.core.Path parent = this.toRemote(file.getParent());
        ch.cyberduck.core.Path temporary = new ch.cyberduck.core.Path(parent, file.getName(), file.getType());
        try {
            remote = this.fileid.reverse(this.fileid.get(temporary));
        }
        catch (NotfoundException e) {
            log.warn(String.format("File %s not found in file id cache", temporary.getAbsolute()));
            remote = temporary;
        }
        if (remote.isSymbolicLink() && null != file.getSymlinkTarget()) {
            remote.setSymlinkTarget(this.toRemote(file.getSymlinkTarget().withAttributes(file.getSymlinkTarget().attributes())));
        }
        remote.setType(this.type(remote));
        return remote.withAttributes(this.getattr(remote, true));
    }

    public ch.cyberduck.core.Path toInternal(ch.cyberduck.core.Path file) {
        if (file.isRoot()) {
            return this.rootWithVersion;
        }
        if (file.equals((Object)this.rootWithVersion)) {
            return file;
        }
        if (file.isChild(this.rootWithVersion)) {
            return file;
        }
        PathAttributes attr = new PathAttributes(file.attributes());
        ch.cyberduck.core.Path parent = new ch.cyberduck.core.Path(this.rootWithVersion.getAbsolute() + file.getParent().getAbsolute(), EnumSet.of(AbstractPath.Type.directory));
        ch.cyberduck.core.Path internal = new ch.cyberduck.core.Path(parent, file.getName(), file.getType(), attr);
        if (internal.isSymbolicLink()) {
            internal.setSymlinkTarget(this.toInternal(file.getSymlinkTarget()));
        }
        return internal;
    }

    public void invalidate(ch.cyberduck.core.Path file) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set placeholder flag for directory %s", file));
        }
        Local local = this.toLocal(file);
        this.metadata.write(local, MetadataStorage.Key.placeholder, new NSDictionary());
        this.localCache.remove((Object)new FilesystemCacheReference(file));
    }

    public EnumSet<AbstractPath.Type> type(ch.cyberduck.core.Path file) {
        return this.type(this.toLocal(file));
    }

    public EnumSet<AbstractPath.Type> type(Local local) {
        NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.type);
        if (null == dict) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Missing type information in metadata storage for file %s", local));
            }
            return local.getType();
        }
        EnumSet<AbstractPath.Type> type = EnumSet.noneOf(AbstractPath.Type.class);
        String typeObj = dict.objectForKey("Type").toString();
        for (String t : StringUtils.splitByWholeSeparator((String)StringUtils.replaceEach((String)typeObj, (String[])new String[]{"[", "]"}, (String[])new String[]{"", ""}), (String)", ")) {
            type.add(AbstractPath.Type.valueOf((String)t));
        }
        if (type.contains(AbstractPath.Type.symboliclink) && !local.isSymbolicLink()) {
            type.remove(AbstractPath.Type.symboliclink);
        }
        return type;
    }

    public PathAttributes getattr(ch.cyberduck.core.Path file, boolean cached) {
        return this.getattr(this.toLocal(file));
    }

    public boolean setattr(ch.cyberduck.core.Path file, long timestamp) throws BackgroundException {
        Local local = this.toLocal(file);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set modification date %s for %s saved in cache as %s", timestamp, file, local));
        }
        this.metadata.write(local, MetadataStorage.Key.modificationdate, MetadataStorage.Key.modificationdate.toDictionary(timestamp));
        return true;
    }

    public boolean setattr(ch.cyberduck.core.Path file, Permission permission) throws BackgroundException {
        Local local = this.toLocal(file);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set permission %s for %s saved in cache as %s", permission, file, local));
        }
        this.metadata.write(local, MetadataStorage.Key.permission, (NSDictionary)permission.serialize(SerializerFactory.get()));
        return true;
    }

    public PathAttributes getattr(Local local) {
        PathAttributes attr;
        FileStatusService.SyncState status = this.placeholderStatusService.getStatus(local).getState();
        switch (status) {
            case unknown: 
            case local: 
            case ignored: {
                attr = new PathAttributes();
                break;
            }
            default: {
                NSDictionary meta = this.metadata.read(local, MetadataStorage.Key.metadata);
                if (null == meta) {
                    log.warn(String.format("Missing metadata for %s", local));
                    attr = new PathAttributes();
                    break;
                }
                attr = new PathAttributesDictionary().deserialize((Object)meta);
            }
        }
        switch (status) {
            case local: 
            case synced: {
                LocalAttributes l = local.attributes();
                attr.setSize(l.getSize());
                NSDictionary dict = this.metadata.read(local, MetadataStorage.Key.permission);
                if (null != dict) {
                    attr.setPermission(new PermissionDictionary().deserialize((Object)dict));
                } else if (Permission.EMPTY == attr.getPermission() && local.exists()) {
                    Permission permission = l.getPermission();
                    attr.setPermission(Permission.EMPTY == permission ? Permission.EMPTY : new Permission(permission));
                }
                dict = this.metadata.read(local, MetadataStorage.Key.modificationdate);
                if (null != dict) {
                    attr.setModificationDate(Long.parseLong(dict.get((Object)"Timestamp").toString()));
                    break;
                }
                if (-1L != attr.getModificationDate()) break;
                log.debug(String.format("Missing modification date for file %s", local));
                if (!local.exists()) break;
                attr.setModificationDate(l.getModificationDate());
                break;
            }
        }
        return attr;
    }

    public void setattr(ch.cyberduck.core.Path file, EnumSet<AbstractPath.Type> filetype, PathAttributes attributes, boolean prune) {
        Local local = this.toLocal(file, true);
        NSDictionary type = new NSDictionary();
        if (file.isSymbolicLink() && !this.preferences.getBoolean("fs.symlink.enable")) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Remove unsupported symboliclink type for %s saved in cache as %s", file, local));
            }
            EnumSet<AbstractPath.Type> t = EnumSet.copyOf(filetype);
            t.remove(AbstractPath.Type.symboliclink);
            type.put("Type", (Object)String.valueOf(t));
        } else {
            type.put("Type", (Object)String.valueOf(filetype));
        }
        this.metadata.write(local, MetadataStorage.Key.type, type);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set remote metadata %s for %s saved in cache as %s", attributes, file, local));
        }
        this.metadata.write(local, MetadataStorage.Key.metadata, (NSDictionary)attributes.serialize(SerializerFactory.get()));
        if (prune) {
            if (-1L != attributes.getModificationDate() && this.metadata.read(local, MetadataStorage.Key.modificationdate) != null) {
                log.warn(String.format("Reset modification date %s for %s", this.metadata.read(local, MetadataStorage.Key.modificationdate), file));
                this.metadata.delete(local, MetadataStorage.Key.modificationdate);
            }
            if (!Permission.EMPTY.equals((Object)attributes.getPermission()) && this.metadata.read(local, MetadataStorage.Key.permission) != null) {
                log.warn(String.format("Reset permission mask %s for %s", this.metadata.read(local, MetadataStorage.Key.permission), file));
                this.metadata.delete(local, MetadataStorage.Key.permission);
            }
        }
        this.metadata.write(local, MetadataStorage.Key.timestamp, MetadataStorage.Key.timestamp.toDictionary());
    }

    public Set<ch.cyberduck.core.Path> delete(ch.cyberduck.core.Path file) throws BackgroundException {
        return this.purge(file, true);
    }

    public Set<ch.cyberduck.core.Path> trash(ch.cyberduck.core.Path file) throws BackgroundException {
        return this.purge(file, false);
    }

    private Set<ch.cyberduck.core.Path> purge(ch.cyberduck.core.Path file, boolean retain) throws BackgroundException {
        HashSet<ch.cyberduck.core.Path> purged = new HashSet<ch.cyberduck.core.Path>();
        Local local = this.toLocal(file);
        this.metadata.flush(local);
        if (retain) {
            this.metadata.purge(local);
        } else {
            for (MetadataStorage.Key key : MetadataStorage.Key.values()) {
                this.metadata.delete(local, key);
            }
        }
        this.metadata.flush(local);
        if (file.isDirectory()) {
            ch.cyberduck.core.Path next;
            FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(new Host((Protocol)new LocalProtocol()));
            this.list(file, (FilesystemListProgressListener)listener, 0L);
            while ((next = listener.next()) != null) {
                purged.addAll(this.purge(next, retain));
            }
        }
        this.localCache.remove((Object)new FilesystemCacheReference(file));
        this.fileid.remove(file);
        purged.add(file);
        return purged;
    }

    public Map<ch.cyberduck.core.Path, ch.cyberduck.core.Path> rename(ch.cyberduck.core.Path file, ch.cyberduck.core.Path target) throws BackgroundException {
        this.metadata.purge(this.toLocal(target));
        block3: for (MetadataStorage.Key key : MetadataStorage.Key.values()) {
            switch (key) {
                case delete: {
                    this.metadata.delete(this.toLocal(target), MetadataStorage.Key.delete);
                    continue block3;
                }
                default: {
                    NSDictionary dict = this.metadata.read(this.toLocal(file), key);
                    if (null == dict) continue block3;
                    this.metadata.write(this.toLocal(target), key, dict);
                }
            }
        }
        this.metadata.purge(this.toLocal(file));
        this.localCache.remove((Object)new FilesystemCacheReference(file));
        if (file.isDirectory()) {
            for (FilesystemCacheReference f : this.localCache.asMap().keySet()) {
                if (f.getFile().isChild(file)) {
                    this.localCache.remove((Object)f);
                }
                if (!f.getFile().isChild(target)) continue;
                this.localCache.remove((Object)f);
            }
        }
        return Collections.singletonMap(file, target);
    }

    public boolean contains(ch.cyberduck.core.Path file, FilesystemCallbacks.Mode flags) {
        return false;
    }

    public MarkerBuffer buffer(ch.cyberduck.core.Path file) {
        return new NullBuffer();
    }

    public void open(ch.cyberduck.core.Path file, FilesystemCallbacks.Mode flags, Long allocate, Application application) {
        this.metadata.write(this.toLocal(file), MetadataStorage.Key.lastaccess, MetadataStorage.Key.lastaccess.toDictionary());
    }

    public TransferStatus close(ch.cyberduck.core.Path file, FilesystemCallbacks.Mode flags, Application application, boolean releaseLock) throws BackgroundException {
        this.metadata.write(this.toLocal(file), MetadataStorage.Key.lastaccess, MetadataStorage.Key.lastaccess.toDictionary());
        return null;
    }

    public List<Object> lock(ch.cyberduck.core.Path file) {
        return Collections.emptyList();
    }

    public void unlock(ch.cyberduck.core.Path file) {
    }

    public String getLock(ch.cyberduck.core.Path file) {
        NSObject value;
        if (!this.preferences.getBoolean("fs.lock.enable")) {
            return null;
        }
        NSDictionary lockid = this.metadata.read(this.toLocal(file), MetadataStorage.Key.lockid);
        if (lockid != null && (value = lockid.objectForKey(MetadataStorage.Key.lockid.name())) != null) {
            return value.toString();
        }
        return null;
    }

    public Quota.Space quota(ch.cyberduck.core.Path workdir) {
        NSDictionary dict = this.metadata.read(this.toLocal(workdir), MetadataStorage.Key.quota);
        if (null == dict) {
            return QUOTA_UNKNOWN;
        }
        return new Quota.Space(Long.valueOf(dict.objectForKey("used").toString()), Long.valueOf(dict.objectForKey("available").toString()));
    }

    private ch.cyberduck.core.Path resolve(ch.cyberduck.core.Path file) {
        if (file.isRoot()) {
            return file;
        }
        NSDictionary dict = this.metadata.read((Local)this.localCache.get((Object)new FilesystemCacheReference(file)), MetadataStorage.Key.rename);
        if (dict != null) {
            ch.cyberduck.core.Path renamed = new PathDictionary().deserialize((Object)dict.objectForKey("Path"));
            if (new SimplePathPredicate(file).test(renamed)) {
                return file;
            }
            log.warn(String.format("Resolved %s to %s from metadata in cache", file, renamed));
            return this.resolve(new ch.cyberduck.core.Path(this.resolve(renamed.getParent()), renamed.getName(), renamed.getType(), renamed.attributes()));
        }
        return new ch.cyberduck.core.Path(this.resolve(file.getParent()), file.getName(), file.getType(), file.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetadataLocalCache{");
        sb.append("directory=").append(this.directoryWithVersion);
        sb.append(", root=").append(this.rootWithVersion);
        sb.append('}');
        return sb.toString();
    }
}

