/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.cache;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.sync.cache.MetadataLocalCache;

public class LocalCacheListProgressListener
extends IndexedListProgressListener {
    private final MetadataLocalCache cache;
    private final Path parent;
    private final FilesystemListProgressListener proxy;

    public LocalCacheListProgressListener(MetadataLocalCache cache, Path folder, FilesystemListProgressListener proxy) {
        this.cache = cache;
        this.parent = folder;
        this.proxy = proxy;
    }

    public void message(String message) {
        this.proxy.message(message);
    }

    public void chunk(Path folder, AttributedList<Path> list) throws ConnectionCanceledException {
        super.chunk(folder, list);
        this.proxy.chunk(this.parent, list);
    }

    public void visit(AttributedList<Path> list, int i, Path file) throws ConnectionCanceledException {
        switch (this.cache.getState()) {
            case closed: {
                throw new ConnectionCanceledException();
            }
        }
        Path remote = this.cache.toRemote(file);
        list.set(i, (Referenceable)remote.withAttributes(this.cache.getattr(remote, true)));
    }

    public IndexedListProgressListener reset() throws ConnectionCanceledException {
        this.proxy.reset();
        return this;
    }
}

