/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.cache;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalCacheFactory
extends Factory<LocalCache<?>> {
    private static final Logger log = LogManager.getLogger((String)LocalCacheFactory.class.getName());

    protected LocalCacheFactory() {
        super("factory.sync.cache.class");
    }

    public static <Inode> LocalCache<Inode> get(Controller controller, Host bookmark, Local directory, FileidMapper<?> fileid, MetadataService<?> metadata) {
        return new LocalCacheFactory().create(controller, bookmark, directory, fileid, metadata);
    }

    private <Inode> LocalCache<Inode> create(Controller controller, Host bookmark, Local directory, FileidMapper<?> fileid, MetadataService<?> metadata) {
        String clazz = PreferencesFactory.get().getProperty("factory.sync.cache.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", ((Object)((Object)this)).getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{controller.getClass(), bookmark.getClass(), directory.getClass(), fileid.getClass(), metadata.getClass()});
            return (LocalCache)constructor.newInstance(controller, bookmark, directory, fileid, metadata);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException var6) {
            log.error(String.format("Failure loading callback class %s. %s", clazz, var6.getMessage()));
            throw new FactoryException();
        }
    }
}

