/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.cache;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.exception.FilesystemIOExceptionMappingService;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.cache.SessionLocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileChannelLocalCache<Inode>
extends SessionLocalCache<Inode>
implements LocalCache<Inode> {
    private static final Logger log = LogManager.getLogger((String)FileChannelLocalCache.class.getName());
    private final LRUCache<Local, FileChannel> readChannelCache = LRUCache.usingLoader(this::openReadChannel, (long)PreferencesFactory.get().getLong("fs.sync.filechannel.cache.size"));
    private final LRUCache<Local, FileChannel> writeChannelCache = LRUCache.usingLoader(this::openWriteChannel, (long)PreferencesFactory.get().getLong("fs.sync.filechannel.cache.size"));

    public FileChannelLocalCache(Controller controller, Host bookmark, Local directory, FileidMapper<Inode> fileid, MetadataService<?> metadata) {
        super(controller, bookmark, directory, fileid, metadata);
    }

    private FileChannel openReadChannel(Local local) {
        try {
            return FileChannel.open(Paths.get(local.getAbsolute(), new String[0]), StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    private FileChannel openWriteChannel(Local local) {
        try {
            return FileChannel.open(Paths.get(local.getAbsolute(), new String[0]), StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    @Override
    public void close() throws BackgroundException {
        this.readChannelCache.asMap().forEach((local, fileChannel) -> {
            try {
                this.closeChannel(this.readChannelCache, (Local)local);
            }
            catch (BackgroundException e) {
                log.warn(String.format("Failure closing file channel for %s", local));
            }
        });
        this.writeChannelCache.asMap().forEach((local, fileChannel) -> {
            try {
                this.closeChannel(this.writeChannelCache, (Local)local);
            }
            catch (BackgroundException e) {
                log.warn(String.format("Failure closing file channel for %s", local));
            }
        });
        super.close();
    }

    public void truncate(Path file, long size) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Truncate file %s", file));
        }
        switch (this.getState()) {
            case closed: {
                throw new ConnectionCanceledException();
            }
        }
        Local local = this.toLocal(file);
        try {
            this.closeChannel(this.readChannelCache, local);
            FileChannel channel = ((FileChannel)this.writeChannelCache.get((Object)local)).truncate(size);
            long remaining = size - channel.size();
            if (remaining > 0L) {
                channel.write(ByteBuffer.allocate(1), size - 1L);
            }
            this.closeChannel(this.writeChannelCache, local);
        }
        catch (UncheckedExecutionException e) {
            if (ExceptionUtils.getRootCause((Throwable)e) instanceof IOException) {
                throw new FilesystemIOExceptionMappingService().map((IOException)ExceptionUtils.getRootCause((Throwable)e));
            }
            throw new BackgroundException(ExceptionUtils.getRootCause((Throwable)e));
        }
        catch (IOException e) {
            throw new FilesystemIOExceptionMappingService().map(e);
        }
    }

    @Override
    public Set<Path> delete(Path file) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Delete file %s", file));
        }
        if (file.isFile()) {
            this.close(file, FilesystemCallbacks.Mode.read, Application.notfound);
            this.close(file, FilesystemCallbacks.Mode.write, Application.notfound);
        }
        return super.delete(file);
    }

    @Override
    public Set<Path> trash(Path file) throws BackgroundException {
        if (file.isFile()) {
            this.close(file, FilesystemCallbacks.Mode.read, Application.notfound);
            this.close(file, FilesystemCallbacks.Mode.write, Application.notfound);
        }
        return super.trash(file);
    }

    @Override
    public Map<Path, Path> rename(Path file, Path target) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Rename file %s to %s", file, target));
        }
        if (file.isFile()) {
            this.close(file, FilesystemCallbacks.Mode.read, Application.notfound);
            this.close(file, FilesystemCallbacks.Mode.write, Application.notfound);
        }
        return super.rename(file, target);
    }

    @Override
    public int read(Path file, byte[] chunk, long offset, int count) throws BackgroundException {
        switch (this.getState()) {
            case closed: {
                throw new ConnectionCanceledException();
            }
        }
        try {
            Local local = this.toLocal(file);
            this.closeChannel(this.writeChannelCache, local);
            FileChannel channel = (FileChannel)this.readChannelCache.get((Object)local);
            int read = channel.read(ByteBuffer.wrap(chunk, 0, count), offset);
            return Math.min(read, count);
        }
        catch (UncheckedExecutionException e) {
            if (ExceptionUtils.getRootCause((Throwable)e) instanceof IOException) {
                throw new FilesystemIOExceptionMappingService().map((IOException)ExceptionUtils.getRootCause((Throwable)e));
            }
            throw new BackgroundException(ExceptionUtils.getRootCause((Throwable)e));
        }
        catch (IOException e) {
            throw new FilesystemIOExceptionMappingService().map(e);
        }
    }

    @Override
    public int write(Path file, byte[] chunk, int count, long offset) throws BackgroundException {
        switch (this.getState()) {
            case closed: {
                throw new ConnectionCanceledException();
            }
        }
        Local local = this.toLocal(file);
        try {
            this.closeChannel(this.readChannelCache, local);
            FileChannel channel = (FileChannel)this.writeChannelCache.get((Object)local);
            int written = channel.write(ByteBuffer.wrap(chunk, 0, count), offset);
            return Math.min(written, count);
        }
        catch (UncheckedExecutionException e) {
            if (ExceptionUtils.getRootCause((Throwable)e) instanceof IOException) {
                throw new FilesystemIOExceptionMappingService().map((IOException)ExceptionUtils.getRootCause((Throwable)e));
            }
            throw new BackgroundException(ExceptionUtils.getRootCause((Throwable)e));
        }
        catch (IOException e) {
            throw new FilesystemIOExceptionMappingService().map(e);
        }
    }

    @Override
    public TransferStatus close(Path file, FilesystemCallbacks.Mode flags, Application application, boolean releaseLock) throws BackgroundException {
        block0 : switch (this.getState()) {
            case open: {
                switch (flags) {
                    case read: {
                        this.closeChannel(this.readChannelCache, this.toLocal(file));
                        break block0;
                    }
                    case write: {
                        this.closeChannel(this.readChannelCache, this.toLocal(file));
                        this.closeChannel(this.writeChannelCache, this.toLocal(file));
                    }
                }
            }
        }
        return super.close(file, flags, application, releaseLock);
    }

    private void closeChannel(LRUCache<Local, FileChannel> cache, Local local) throws BackgroundException {
        try {
            if (cache.contains((Object)local)) {
                FileChannel channel = (FileChannel)cache.get((Object)local);
                channel.close();
                cache.remove((Object)local);
            }
        }
        catch (IOException e) {
            throw new FilesystemIOExceptionMappingService().map(e);
        }
    }

    public LocalCache.Version version() {
        return new LocalCache.Version(LocalCache.Type.cleartext, 1);
    }
}

