/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.preferences.LogDirectoryFinderFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.ConnectMode;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import ch.iterate.mountainduck.service.ThreadDumpService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.DefaultMetadataService;
import ch.iterate.mountainduck.sync.metadata.ErrorListMetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.metadata.MetadataStorageFactory;
import com.dd.plist.NSDictionary;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ErrorsMetadataDumpService
implements ThreadDumpService {
    private static final Logger log = LogManager.getLogger((String)ErrorsMetadataDumpService.class.getName());

    public void dump() {
        FilesystemMountRegistry registry = FilesystemMountRegistry.get();
        NSDictionary errors = new NSDictionary();
        for (Filesystem fs : registry.values()) {
            if (fs.getMode() == ConnectMode.online) continue;
            LocalCache cache = fs.getLocalCache();
            ErrorListMetadataService metadata = new ErrorListMetadataService((MetadataService)new DefaultMetadataService(MetadataStorageFactory.get()));
            NSDictionary dict = metadata.read(cache.getDirectory(), MetadataStorage.Key.errors);
            if (dict == null) continue;
            errors.putAll((Map)dict.getHashMap());
        }
        Local file = LocalFactory.get((String)LogDirectoryFinderFactory.get().find().getAbsolute(), (String)String.format("%s.errors", StringUtils.replaceChars((String)StringUtils.lowerCase((String)PreferencesFactory.get().getProperty("application.name")), (String)" ", (String)"")));
        try (OutputStream out = file.getOutputStream(false);){
            IOUtils.write((String)errors.toXMLPropertyList(), (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }
        catch (AccessDeniedException | IOException e) {
            log.error(String.format("Failure writing errors to %s", file));
        }
    }
}

