/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemIncrementalListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.conflict.DirectoryConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.conflict.MetadataConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.option.SyncOption;
import ch.iterate.mountainduck.sync.queue.CacheDeleteCallback;
import ch.iterate.mountainduck.sync.queue.CachePlaceholderCallback;
import ch.iterate.mountainduck.sync.queue.CacheSetattrCallback;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.QueueIndexCallback;
import ch.iterate.mountainduck.sync.queue.QueueReadCallback;
import ch.iterate.mountainduck.sync.queue.SyncOperationCanceledException;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncListProgressListener
extends IndexedListProgressListener
implements FilesystemListProgressListener {
    private static final Logger log = LogManager.getLogger((String)SyncListProgressListener.class.getName());
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;
    private final FileHistory history;
    private final FilesystemListProgressListener proxy;
    private final ReloadService reload;
    private final QueueReadCallback read;
    private final QueueIndexCallback index;
    private final CacheSetattrCallback setattr;
    private final CacheDeleteCallback delete;
    private final CachePlaceholderCallback placeholder;
    private final QueueLock<Boolean> lock;
    private final boolean keepOffline;
    private final Path directory;
    private final AtomicReference<BackgroundException> error = new AtomicReference();
    private final NotificationService notifications = NotificationServiceFactory.get();
    private final FilesystemListFilter filter = new FilesystemListFilter();
    private final Map<Path, ReloadService.Change> changeset = new HashMap<Path, ReloadService.Change>();
    private final AttributedList<Path> remote = new AttributedList();
    private final long start;

    public SyncListProgressListener(Host bookmark, Path directory, LocalCache<?> cache, QueueLock<Boolean> lock, SyncOption option, MetadataService<?> metadata, FileHistory history, FilesystemListProgressListener proxy, ReloadService reload, QueueReadCallback read, QueueIndexCallback index, CacheSetattrCallback setattr, CacheDeleteCallback delete, CachePlaceholderCallback placeholder) {
        this.bookmark = bookmark;
        this.cache = cache;
        this.metadata = metadata;
        this.history = history;
        this.proxy = proxy;
        this.directory = directory;
        this.reload = reload;
        this.read = read;
        this.index = index;
        this.setattr = setattr;
        this.delete = delete;
        this.placeholder = placeholder;
        this.lock = lock;
        this.keepOffline = option.include(directory);
        this.start = System.currentTimeMillis();
    }

    public void message(String message) {
        this.proxy.message(message);
    }

    public void visit(AttributedList<Path> list, int i, Path f) throws ConnectionCanceledException {
        if (!this.filter.accept(f)) {
            log.warn(String.format("Skip file %s", f));
            return;
        }
        this.remote.add((Referenceable)f);
        Local local = this.cache.toLocal(f);
        switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(local).getState()) {
            case local: {
                log.warn(String.format("File %s found in cache at %s with missing metadata", f, local));
                break;
            }
            case synced: {
                if (f.isFile()) {
                    switch (new MetadataConflictResolutionStrategy(this.cache, this.metadata).resolve(local, f.attributes())) {
                        case remote: 
                        case notequal: {
                            if (this.read(f, local)) break;
                        }
                        default: {
                            this.setattr(f, local, false);
                            break;
                        }
                    }
                    break;
                }
                switch (new DirectoryConflictResolutionStrategy(this.bookmark, this.metadata).resolve(local, f.attributes())) {
                    case remote: 
                    case notequal: 
                    case unknown: {
                        if (this.index(f, local)) break;
                    }
                    default: {
                        this.setattr(f, local, false);
                        break;
                    }
                }
                break;
            }
            case unknown: {
                if (!this.placeholder(f, local)) break;
                this.changeset.put(f, ReloadService.Change.added);
                if (null != this.metadata.read(this.cache.toLocal(this.directory), MetadataStorage.Key.indexed)) {
                    this.history.add(new FileHistory.Item(f, this.cache.toMount(f), FileHistory.Item.Origin.remote, Operation.write));
                    if (!FilesystemFilenameBlacklist.placeholdernotificationexclude.contains(f)) {
                        this.notifications.notify(BookmarkNameProvider.toString((Host)this.bookmark), this.cache.toMount(f).getAbsolute(), LocaleFactory.localizedString((String)"File Added", (String)"Disk"), f.getName(), LocaleFactory.localizedString((String)"Show", (String)"Localizable"));
                    }
                }
                if (!f.isFile() || !this.keepOffline) break;
                this.read(f, local);
                break;
            }
            case placeholder: {
                this.setattr(f, local, true);
                if (!f.isFile() || !this.keepOffline) break;
                this.read(f, local);
            }
        }
    }

    public void error(BackgroundException failure) {
        if (failure instanceof NotfoundException) {
            log.warn(String.format("Missing directory %s on server. %s", new Object[]{this.directory, failure}));
            this.delete(this.directory, this.cache.toLocal(this.directory));
        }
        this.proxy.error(failure);
        this.error.set(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        try {
            switch (this.cache.getState()) {
                case closed: {
                    log.warn(String.format("Cache %s is closed", this.cache));
                    break;
                }
                default: {
                    Local local = this.cache.toLocal(this.directory);
                    if (!local.exists()) {
                        log.warn(String.format("Missing directory %s in cache", this.directory));
                        break;
                    }
                    try {
                        if (null != this.error.get()) {
                            log.warn(String.format("Skip sync with remote listing after failure %s", new Object[]{this.error.get()}));
                            this.cache.list(this.directory, this.proxy, 0L);
                            break;
                        }
                        AttributedList filtered = this.remote.filter((Filter)this.filter);
                        if (null != this.metadata.read(local, MetadataStorage.Key.indexed)) {
                            Path next;
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Sync directory %s with local cache previously indexed", this.directory));
                            }
                            AttributedList cached = new AttributedList();
                            Set lookup = filtered.toList().stream().map(FilesystemCacheReference::new).collect(Collectors.toCollection(HashSet::new));
                            FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(new Host((Protocol)new LocalProtocol()));
                            this.cache.list(this.directory, (FilesystemListProgressListener)listener, 0L);
                            while ((next = listener.next()) != null) {
                                if (FilesystemFilenameBlacklist.localonly.contains(next)) continue;
                                if (lookup.contains(new FilesystemCacheReference(next))) {
                                    cached.add((Referenceable)next);
                                    continue;
                                }
                                if (this.delete(next, this.cache.toLocal(next))) {
                                    this.changeset.put(next, ReloadService.Change.deleted);
                                    continue;
                                }
                                cached.add((Referenceable)next);
                            }
                            this.proxy.chunk(this.directory, cached);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Skip syncing directory %s with local cache not previously indexed", this.directory));
                            }
                            filtered.toStream().forEach(f -> this.changeset.put((Path)f, ReloadService.Change.added));
                            this.proxy.chunk(this.directory, filtered);
                        }
                        this.metadata.write(local, MetadataStorage.Key.indexed, MetadataStorage.Key.indexed.toDictionary());
                        this.setattr(this.directory, local, true);
                        this.metadata.delete(local, MetadataStorage.Key.placeholder);
                        break;
                    }
                    catch (BackgroundException e) {
                        log.warn(String.format("Failure listing directory %s in cache for %s", local, this.directory));
                    }
                }
            }
            this.proxy.finish();
        }
        finally {
            this.lock.release(this.directory);
            if (!this.changeset.isEmpty()) {
                this.reload.reload(this.directory, this.cache.toMount(this.directory), this.changeset);
            }
        }
    }

    public boolean hasNext() {
        return this.proxy.hasNext();
    }

    public Path next() throws BackgroundException {
        return this.proxy.next();
    }

    public void await() throws BackgroundException {
        this.proxy.await();
    }

    public Path search(String filename) throws BackgroundException {
        return this.proxy.search(filename);
    }

    public SyncListProgressListener reset() throws ConnectionCanceledException {
        if (!this.lock.acquire(this.directory, QueueLock.Option.single).booleanValue()) {
            throw new SyncOperationCanceledException(String.format("Failure to receive lock for %s", this.directory.getName()));
        }
        this.metadata.delete(this.cache.toLocal(this.directory), MetadataStorage.Key.error);
        this.proxy.reset();
        return this;
    }

    private boolean setattr(Path file, Local local, boolean prune) {
        return this.setattr.setattr(file, file.attributes(), local, prune);
    }

    private boolean index(Path file, Local local) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Update directory %s for %s in cache with latest version from remote", file, local));
        }
        this.index.index(local, file);
        return true;
    }

    private boolean read(Path file, Local local) {
        try {
            if (log.isInfoEnabled()) {
                log.info(String.format("Download file %s to cache included for sync by default", file));
            }
            return this.read.read(local, file);
        }
        catch (BackgroundException e) {
            log.error(String.format("Failure %s updating %s with %s in cache", new Object[]{e, file, local}));
            return false;
        }
    }

    private boolean placeholder(Path file, Local local) {
        try {
            return this.placeholder.placeholder(local, file);
        }
        catch (BackgroundException e) {
            log.error(String.format("Failure %s creating placeholder %s for %s in cache", new Object[]{e, local, file}));
            return false;
        }
    }

    private boolean delete(Path file, Local local) {
        try {
            return this.delete.delete(this.start, local, file);
        }
        catch (BackgroundException e) {
            log.error(String.format("Failure %s trashing %s with %s in cache", new Object[]{e, file, local}));
            return false;
        }
    }
}

