/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.QuarantineService;
import ch.cyberduck.core.local.QuarantineServiceFactory;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.PermissionDictionary;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.ConnectMode;
import ch.iterate.mountainduck.fs.DelayedIndexerSubmitter;
import ch.iterate.mountainduck.fs.DelayedQueueSubmitter;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilenameMatchPathPredicate;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemAttributesWorker;
import ch.iterate.mountainduck.fs.FilesystemCacheDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemIncrementalListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemLockWorker;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.FilesystemSessionPool;
import ch.iterate.mountainduck.fs.InodeFilenameComposer;
import ch.iterate.mountainduck.fs.LockPatternService;
import ch.iterate.mountainduck.fs.NotificationServiceAlertCallback;
import ch.iterate.mountainduck.fs.ProxyFilesystemOperations;
import ch.iterate.mountainduck.fs.SyncListProgressListener;
import ch.iterate.mountainduck.fs.badge.FileOverlayIconService;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.service.CacheInvalidatingReloadService;
import ch.iterate.mountainduck.service.DisabledReloadService;
import ch.iterate.mountainduck.service.DiskUsageService;
import ch.iterate.mountainduck.service.DiskUsageServiceFactory;
import ch.iterate.mountainduck.service.FileBadgeService;
import ch.iterate.mountainduck.service.RegionService;
import ch.iterate.mountainduck.service.RegionServiceFactory;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.cache.LocalCacheFactory;
import ch.iterate.mountainduck.sync.cache.LocalCacheIndexer;
import ch.iterate.mountainduck.sync.conflict.MetadataConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.history.FileHistoryFactory;
import ch.iterate.mountainduck.sync.indexer.BlockingDirectoryIndexer;
import ch.iterate.mountainduck.sync.indexer.RecursiveDirectoryIndexer;
import ch.iterate.mountainduck.sync.indexer.ReschedulingDirectoryIndexer;
import ch.iterate.mountainduck.sync.indexer.ThreadedDirectoryIndexer;
import ch.iterate.mountainduck.sync.lock.BlockingQueueLock;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.lock.ReentrantQueueLock;
import ch.iterate.mountainduck.sync.metadata.CachingMetadataService;
import ch.iterate.mountainduck.sync.metadata.DefaultExceptionSerializer;
import ch.iterate.mountainduck.sync.metadata.DefaultMetadataService;
import ch.iterate.mountainduck.sync.metadata.ErrorListMetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.metadata.MetadataStorageFactory;
import ch.iterate.mountainduck.sync.metadata.RenameResolvingMetadataService;
import ch.iterate.mountainduck.sync.metadata.ThreadedMetadataService;
import ch.iterate.mountainduck.sync.option.SelectiveSyncOption;
import ch.iterate.mountainduck.sync.option.SyncOption;
import ch.iterate.mountainduck.sync.queue.DefaultCacheDeleteCallback;
import ch.iterate.mountainduck.sync.queue.DefaultCachePlaceholderCallback;
import ch.iterate.mountainduck.sync.queue.DefaultIndexerIndexCallback;
import ch.iterate.mountainduck.sync.queue.DefaultQueueReadCallback;
import ch.iterate.mountainduck.sync.queue.DefaultSetattrCallback;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.SerializableOperationException;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.sync.queue.SyncQueueFactory;
import ch.iterate.mountainduck.sync.quota.BlockingLocalCacheQuotaIndexer;
import ch.iterate.mountainduck.sync.quota.LocalCacheQuotaStrategy;
import ch.iterate.mountainduck.sync.quota.RecursiveLocalCacheIndexer;
import ch.iterate.mountainduck.sync.quota.ReschedulingLocalCacheQuotaIndexer;
import ch.iterate.mountainduck.sync.quota.ThreadedLocalCacheIndexer;
import ch.iterate.mountainduck.sync.status.BadgeFileStatusService;
import ch.iterate.mountainduck.sync.status.CacheExpiryStatusService;
import ch.iterate.mountainduck.sync.status.ChainedMountStatusService;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import ch.iterate.mountainduck.sync.status.ReachabilityStatusService;
import ch.iterate.mountainduck.sync.status.StaticStatusService;
import ch.iterate.mountainduck.sync.status.SyncQueueStatusService;
import ch.iterate.mountainduck.sync.status.WriteInProgressStatusService;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncFilesystemOperations<Inode>
extends ProxyFilesystemOperations<Inode>
implements FileStatusService,
SyncQueue.Listener,
DirectoryIndexer.Listener {
    private static final Logger log = LogManager.getLogger((String)SyncFilesystemOperations.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final DefaultFailureDiagnostics diagnostics = new DefaultFailureDiagnostics();
    private final DefaultCacheDeleteCallback delete;
    private final DefaultSetattrCallback setattr;
    private final DefaultCachePlaceholderCallback placeholder;
    private Path workdir;
    private final SyncQueue queue;
    private final LocalCache<Inode> local;
    private final FileStatusService badgeStatusService;
    private final MetadataService<NSDictionary> metadata;
    private final FileHistory history;
    private final FileStatusService createSwitch;
    private final FileStatusService writeSwitch;
    private final FileStatusService readSwitch;
    private final FileStatusService listSwitch;
    private final FileidMapper<Inode> fileid;
    private final FilesystemDirectoryGenerations generations;
    private final ReachabilityStatusService reachability;
    private final DirectoryIndexer directoryIndexer;
    private final DirectoryIndexer directoryIndexerScheduler;
    private final LocalCacheIndexer localCacheIndexerScheduler;
    private final Controller controller;
    private final Host bookmark;
    private final FileBadgeService badge;
    private final QuarantineService quarantineService = QuarantineServiceFactory.get();
    private final AlertCallback alert = new NotificationServiceAlertCallback();
    private final SyncOption options;
    private final DelayedQueueSubmitter delayedQueueSubmitter;
    private final DelayedIndexerSubmitter delayedIndexerSubmitter;
    private final DiskUsageService diskUsageService = DiskUsageServiceFactory.get();
    private final ReentrantQueueLock cacheLock = new ReentrantQueueLock();
    private final QueueLock<Boolean> blockingCacheLock = new BlockingQueueLock(this.cacheLock);
    private final Set<FilesystemCacheReference> owners = ConcurrentHashMap.newKeySet();
    private final FilesystemSessionPool pool;
    private final ReloadService reload;
    private final FilesystemOperations<Inode> proxy;
    private final InodeFilenameComposer<Inode> composer;
    private final Lock sync = new ReentrantLock();

    public SyncFilesystemOperations(FilesystemOperations<Inode> proxy, Controller controller, Host bookmark, FilesystemSessionPool pool, FileidMapper<Inode> fileid, FilesystemDirectoryGenerations dirgen, FileBadgeService badge, ReloadService reload) {
        super(proxy);
        this.controller = controller;
        this.bookmark = bookmark;
        this.proxy = proxy;
        this.fileid = fileid;
        this.pool = pool;
        this.reload = reload;
        this.generations = new FilesystemCacheDirectoryGenerations(dirgen, proxy.getCache());
        Local directory = LocalCache.directory((Host)bookmark);
        this.metadata = new ErrorListMetadataService((MetadataService)new CachingMetadataService((MetadataService)new ThreadedMetadataService((MetadataService)new RenameResolvingMetadataService((MetadataService)new DefaultMetadataService(MetadataStorageFactory.get())))));
        this.local = LocalCacheFactory.get(controller, bookmark, directory, fileid, this.metadata);
        this.metadata.open(this.local.getDirectory());
        this.badge = badge;
        this.history = FileHistoryFactory.get((Local)SyncQueue.directory((Host)bookmark));
        this.queue = SyncQueueFactory.get(controller, (SessionPool)pool, this.local, this.blockingCacheLock, this.metadata, this.history, (ReloadService)new CacheInvalidatingReloadService(this.generations, reload));
        this.badgeStatusService = new BadgeFileStatusService(this.queue, this.local, this.metadata);
        this.options = new SelectiveSyncOption(this.local, this.metadata);
        this.delete = new DefaultCacheDeleteCallback(bookmark, this.local, this.metadata, this.history, this);
        this.setattr = new DefaultSetattrCallback(bookmark, this.local, this.metadata, this.history);
        this.placeholder = new DefaultCachePlaceholderCallback(this.local, this.metadata);
        this.directoryIndexer = new ThreadedDirectoryIndexer(new BlockingDirectoryIndexer(controller, (SessionPool)this.pool, this.local, this.cacheLock, this.options, this.metadata, this.history, this.queue, this.generations, new DefaultQueueReadCallback(this.queue, this.local, this.metadata), this.delete, this.setattr, this.placeholder));
        this.directoryIndexerScheduler = new ReschedulingDirectoryIndexer(new RecursiveDirectoryIndexer(bookmark, this.directoryIndexer, this.local, this.metadata));
        this.localCacheIndexerScheduler = new ReschedulingLocalCacheQuotaIndexer(new RecursiveLocalCacheIndexer(new ThreadedLocalCacheIndexer(new BlockingLocalCacheQuotaIndexer(bookmark, this.local, this.metadata, this.queue))), this.local, this.metadata);
        this.reachability = new ReachabilityStatusService(this.queue, this.directoryIndexerScheduler, bookmark);
        this.createSwitch = new ChainedMountStatusService(new StaticStatusService(new FileStatusService.Status(FileStatusService.SyncState.synced)));
        this.writeSwitch = new ChainedMountStatusService(new PlaceholderStatusService(this.local, this.metadata), new StaticStatusService(new FileStatusService.Status(FileStatusService.SyncState.synced)));
        this.readSwitch = new ChainedMountStatusService(this.reachability, new PlaceholderStatusService(this.local, this.metadata), new StaticStatusService(new FileStatusService.Status(FileStatusService.SyncState.remote)));
        this.listSwitch = new ChainedMountStatusService(this.reachability, new CacheExpiryStatusService(MetadataStorage.Key.indexed, this.local, this.metadata), new PlaceholderStatusService(this.local, this.metadata), new StaticStatusService(new FileStatusService.Status(FileStatusService.SyncState.remote)));
        this.delayedQueueSubmitter = new DelayedQueueSubmitter((FilesystemOperations<?>)this, this.queue);
        this.delayedIndexerSubmitter = new DelayedIndexerSubmitter((FilesystemOperations<?>)this, new DefaultIndexerIndexCallback(bookmark, this.local, this.metadata, this.directoryIndexer, this.reachability, this.badgeStatusService, reload));
        this.composer = new InodeFilenameComposer(fileid);
    }

    public ConnectMode getMode() {
        return ConnectMode.selective;
    }

    public LocalCache<?> getLocalCache() {
        return this.local;
    }

    public DirectoryIndexer getIndexer() {
        return this.directoryIndexer;
    }

    public FilesystemDirectoryGenerations getGenerations() {
        return this.generations;
    }

    public FilesystemSessionPool getPool() {
        return this.pool;
    }

    public FileHistory getHistory() {
        return this.history;
    }

    public MetadataService<?> getMetadataService() {
        return this.metadata;
    }

    public SyncQueue getQueue() {
        return this.queue;
    }

    public FilesystemOperations<Inode> open(Path workdir, Local mountpoint) throws BackgroundException {
        this.workdir = workdir;
        this.proxy.open(workdir, mountpoint);
        this.history.open();
        this.local.open(workdir, mountpoint);
        this.local.setattr(workdir, workdir.getType(), workdir.attributes());
        this.queue.withListener((SyncQueue.Listener)this).open();
        if (this.preferences.getBoolean("fs.sync.indexer.enable")) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Start indexer for workdir %s", workdir));
            }
            this.directoryIndexerScheduler.withListener((DirectoryIndexer.Listener)this).index(workdir, DirectoryIndexer.NO_CALLBACK, ThreadPool.Priority.norm, this.reload);
        }
        if (this.preferences.getBoolean("fs.sync.cache.indexer.enable")) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Start quota indexer for workdir %s", workdir));
            }
            this.localCacheIndexerScheduler.index(workdir, LocalCacheQuotaStrategy.NO_OP, ThreadPool.Priority.norm);
        }
        return this;
    }

    public void close() {
        this.localCacheIndexerScheduler.shutdown();
        this.directoryIndexerScheduler.shutdown();
        this.reachability.shutdown();
        this.delayedQueueSubmitter.close();
        try {
            this.queue.close();
        }
        catch (BackgroundException e) {
            log.error(String.format("Unhandled failure %s closing sync queue", new Object[]{e}));
        }
        this.pool.shutdown();
        this.metadata.close();
        try {
            this.history.close();
        }
        catch (BackgroundException e) {
            log.error(String.format("Unhandled failure %s closing history", new Object[]{e}));
        }
        try {
            this.local.close();
        }
        catch (BackgroundException e) {
            log.error(String.format("Unhandled failure %s closing cache", new Object[]{e}));
        }
    }

    public Filesystem.State getMountStatus() {
        switch (this.queue.getStatus()) {
            case none: {
                switch (this.pool.getState()) {
                    case opening: 
                    case closing: 
                    case open: {
                        return Filesystem.State.busy;
                    }
                }
                return Filesystem.State.closed;
            }
            case busy: 
            case paused: 
            case stopped: {
                return Filesystem.State.busy;
            }
        }
        return Filesystem.State.idle;
    }

    public Path reverse(Inode inode) throws BackgroundException {
        Path file = this.fileid.reverse(inode);
        return file.withAttributes(this.getattr(file));
    }

    public FileOverlayIconService.Badge getBadge(Path file) {
        FileStatusService.Status status = this.getStatus(file);
        switch (status.getState()) {
            case error: {
                return FileOverlayIconService.Badge.error;
            }
            case inprogress: {
                switch (this.queue.getStatus()) {
                    case paused: 
                    case stopped: {
                        return FileOverlayIconService.Badge.paused;
                    }
                }
                return FileOverlayIconService.Badge.inprogress;
            }
            case remote: {
                return FileOverlayIconService.Badge.online;
            }
            case synced: {
                if (new SelectiveSyncOption(this.local, this.metadata).include(file)) {
                    return FileOverlayIconService.Badge.synced;
                }
                return FileOverlayIconService.Badge.uptodate;
            }
        }
        switch (this.queue.getStatus()) {
            case paused: {
                return FileOverlayIconService.Badge.paused;
            }
        }
        return FileOverlayIconService.Badge.ignored;
    }

    public FileStatusService.Status reset(Path file, FileStatusService.Status status) {
        return this.badgeStatusService.reset(file, status);
    }

    public FileStatusService.Status getStatus(Path file) {
        switch (this.getMountStatus()) {
            case closed: {
                if (this.local.getDirectory().exists()) {
                    return new FileStatusService.Status(FileStatusService.SyncState.synced);
                }
                return new FileStatusService.Status(FileStatusService.SyncState.remote);
            }
        }
        FileStatusService.Status s = this.badgeStatusService.getStatus(file);
        switch (s.getState()) {
            case unknown: {
                return new FileStatusService.Status(FileStatusService.SyncState.remote);
            }
        }
        return s;
    }

    public void indexerStatusChanged(DirectoryIndexer.Status status, BackgroundException failure) {
        this.sync.lock();
        try {
            this.badge.refresh(Collections.singletonMap(this.local.toMount(this.workdir), new FileBadgeService.PathOperation(this.workdir, Operation.list)), status);
        }
        finally {
            this.sync.unlock();
        }
        this.reachability.indexerStatusChanged(status, failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileStatusChanged(Set<Path> files, Operation operation, FileStatusService.Status status) {
        this.sync.lock();
        try {
            HashMap<Local, FileBadgeService.PathOperation> recursive = new HashMap<Local, FileBadgeService.PathOperation>();
            block12: for (Path file : files) {
                block1 : switch (status.getState()) {
                    case unknown: {
                        switch (operation) {
                            case read: 
                            case write: {
                                break block1;
                            }
                        }
                        status = new SyncQueueStatusService(this.queue, this.local, this.metadata).getStatus(file);
                    }
                }
                Path f = file;
                while (new FilesystemCacheReference(f).isChild((SimplePathPredicate)new FilesystemCacheReference(this.workdir)) || new FilesystemCacheReference(f).test(this.workdir)) {
                    FileStatusService.Status previous;
                    if (f.isFile()) {
                        previous = this.badgeStatusService.reset(f, status);
                    } else {
                        if (status.getState() != FileStatusService.SyncState.error) {
                            switch (status.getState()) {
                                case inprogress: {
                                    break;
                                }
                                default: {
                                    FileStatusService.Status qstatus = new SyncQueueStatusService(this.queue, this.local, this.metadata).getStatus(f);
                                    if (qstatus.getState() == FileStatusService.SyncState.unknown) break;
                                    status = qstatus;
                                }
                            }
                        }
                        previous = this.badgeStatusService.reset(f, status);
                    }
                    if (this.preferences.getBoolean("nativity.badge.parent.refresh") || f == file) {
                        if (previous.equals((Object)status)) {
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Skip badge refresh with unchanged status %s for file %s after operation %s", status, f, operation));
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Add badge refresh with changed status %s (previous %s) for file %s after operation %s", status, previous, f, operation));
                            }
                            recursive.put(this.local.toMount(f), new FileBadgeService.PathOperation(f, operation));
                        }
                    }
                    if (f.isRoot()) continue block12;
                    f = f.getParent();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Notify badge with operation %s for files %s with status %s", operation, Arrays.toString(recursive.keySet().toArray()), status));
            }
            this.badge.refresh(recursive, this.queue.getStatus());
        }
        finally {
            this.sync.unlock();
        }
    }

    public void queueStatusChanged(SyncQueue.Status status, BackgroundException failure) {
        this.sync.lock();
        try {
            this.badge.refresh(Collections.emptyMap(), status);
        }
        finally {
            this.sync.unlock();
        }
        this.reachability.queueStatusChanged(status, failure);
    }

    public void transferStatusChanged(TransferProgress progress) {
        this.sync.lock();
        try {
            this.badge.refresh(progress);
        }
        finally {
            this.sync.unlock();
        }
    }

    public void invalidate(Path workdir) {
        this.local.invalidate(workdir);
        this.proxy.invalidate(workdir);
    }

    public void open(Path file, FilesystemCallbacks.Mode flags, Long allocate, Application application) throws BackgroundException {
        block4 : switch (flags) {
            case read: {
                switch (this.readSwitch.getStatus(file).getState()) {
                    case remote: {
                        this.proxy.open(file, flags, allocate, application);
                        if (!this.preferences.getBoolean("fs.buffer.enable")) break block4;
                        MarkerBuffer buffer = this.proxy.buffer(file);
                        try {
                            buffer.withLimit(this.diskUsageService.find((Local)LocalFactory.get((String)this.preferences.getProperty((String)"tmp.dir"))).available);
                        }
                        catch (LocalAccessDeniedException e) {
                            buffer.withLimit(Long.valueOf(Long.MAX_VALUE));
                        }
                        break;
                    }
                    case placeholder: {
                        try {
                            this.proxy.open(file, flags, allocate, application);
                        }
                        catch (NotfoundException e) {
                            switch (this.readSwitch.getStatus(file).getState()) {
                                case placeholder: {
                                    log.warn(String.format("Delete file %s in cache no longer found on server", file));
                                    this.delete.delete(this.local.toLocal(file), file);
                                    this.invalidate(file.getParent());
                                    break;
                                }
                                default: {
                                    this.error(new SerializableOperation(Operation.read, this.local.toLocal(file), file), (BackgroundException)((Object)e));
                                }
                            }
                            throw e;
                        }
                        catch (BackgroundException e) {
                            this.error(new SerializableOperation(Operation.read, this.local.toLocal(file), file), e);
                            throw e;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Allocate unlimited buffer for file %s", file));
                        }
                        if (!this.preferences.getBoolean("fs.buffer.enable")) break block4;
                        MarkerBuffer buffer = this.proxy.buffer(file);
                        try {
                            buffer.withLimit(this.diskUsageService.find((Local)LocalFactory.get((String)this.preferences.getProperty((String)"tmp.dir"))).available);
                        }
                        catch (LocalAccessDeniedException e) {
                            buffer.withLimit(Long.valueOf(Long.MAX_VALUE));
                        }
                        break;
                    }
                    default: {
                        Long currentsize = allocate;
                        block14 : switch (this.reachability.getStatus(file).getState()) {
                            case local: {
                                break;
                            }
                            default: {
                                switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(file).getState()) {
                                    case synced: {
                                        if (!FilesystemFilenameBlacklist.nocache.contains(file) || FilesystemFilenameBlacklist.blacklist.contains(file) || FilesystemFilenameBlacklist.lockowner.contains(file) || this.contains(file, FilesystemCallbacks.Mode.write)) break block14;
                                        if (log.isDebugEnabled()) {
                                            log.debug(String.format("Determine if cached file attributes for %s have expired", file));
                                        }
                                        switch (new CacheExpiryStatusService(MetadataStorage.Key.timestamp, this.local, this.metadata).withExpiry(this.preferences.getLong("fs.getattr.cache.expiry.ms")).getStatus(file).getState()) {
                                            case remote: 
                                            case unknown: {
                                                log.warn(String.format("Read latest remote attributes for %s", file));
                                                PathAttributes remote = (PathAttributes)this.pool.await((Worker)new FilesystemAttributesWorker(file));
                                                switch (new MetadataConflictResolutionStrategy(this.local, this.metadata).resolve(this.local.toLocal(file), remote)) {
                                                    case remote: 
                                                    case notequal: {
                                                        if (log.isDebugEnabled()) {
                                                            log.debug(String.format("Update attributes in cache for %s with %s", file, remote));
                                                        }
                                                        this.local.invalidate(file);
                                                        new DefaultSetattrCallback(this.bookmark, this.local, this.metadata, this.history).setattr(file, remote, this.local.toLocal(file), false);
                                                        currentsize = remote.getSize();
                                                        break block14;
                                                    }
                                                }
                                                this.metadata.write(this.local.toLocal(file), MetadataStorage.Key.timestamp, MetadataStorage.Key.timestamp.toDictionary());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        this.local.open(file, flags, currentsize, application);
                        break;
                    }
                }
                break;
            }
            default: {
                switch (this.writeSwitch.getStatus(file).getState()) {
                    case remote: {
                        try {
                            this.proxy.open(file, flags, allocate, application);
                            break block4;
                        }
                        catch (BackgroundException e) {
                            this.error(new SerializableOperation(Operation.write, this.local.toLocal(file), file), e);
                            throw e;
                        }
                    }
                }
                if (FilesystemFilenameBlacklist.lockinitiators.contains(file)) {
                    switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(file).getState()) {
                        case local: 
                        case ignored: {
                            break;
                        }
                        default: {
                            this.lock(file);
                        }
                    }
                }
                this.local.open(file, flags, allocate, application);
            }
        }
    }

    public TransferStatus close(Path file, FilesystemCallbacks.Mode flags, Application application, boolean releaseLock) throws BackgroundException {
        switch (flags) {
            case read: {
                switch (this.readSwitch.getStatus(file).getState()) {
                    case remote: {
                        return this.proxy.close(file, flags, application);
                    }
                    case placeholder: {
                        MarkerBuffer buffer = this.proxy.buffer(file);
                        if (buffer.isEmpty() && this.getattr(file).getSize() == 0L) {
                            log.warn(String.format("Delete placeholder flag for empty file %s", file));
                            this.metadata.delete(this.local.toLocal(file), MetadataStorage.Key.placeholder);
                        }
                        if (buffer.isComplete()) {
                            this.copyBufferToLocalCache(file, buffer);
                        } else {
                            log.warn(String.format("Missing or incomplete buffer for file %s", file));
                            if (this.preferences.getBoolean("fs.sync.close.readahead")) {
                                block7 : switch (buffer.getState()) {
                                    case open: {
                                        if (buffer.isEmpty()) {
                                            log.warn(String.format("Skip reading file %s from remote", file));
                                            break;
                                        }
                                        switch (new SyncQueueStatusService(this.queue, this.local, this.metadata).getStatus(file).getState()) {
                                            case inprogress: {
                                                log.warn(String.format("Skip read of file %s with pending operation in queue", file));
                                                break block7;
                                            }
                                        }
                                        this.queue.read(this.local.toLocal(file), file);
                                    }
                                }
                            }
                        }
                        return this.proxy.close(file, flags, application);
                    }
                }
                return this.local.close(file, flags, application);
            }
        }
        switch (this.writeSwitch.getStatus(file).getState()) {
            case remote: 
            case placeholder: {
                return this.proxy.close(file, flags, application);
            }
            case local: {
                this.proxy.invalidate(file.getParent());
            }
        }
        String lockId = this.getLock(file);
        switch (new WriteInProgressStatusService(this.local, this.metadata).getStatus(file).getState()) {
            case inprogress: {
                Delete feature;
                if (FilesystemFilenameBlacklist.temporary.contains(file)) break;
                if (FilesystemFilenameBlacklist.lockowner.contains(file) && !(feature = (Delete)this.pool.getFeature(Delete.class)).isSupported(file)) {
                    log.warn(String.format("Skip writing lock file %s with no delete support", file));
                    this.metadata.delete(this.local.toLocal(file), MetadataStorage.Key.write);
                    break;
                }
                this.delayedQueueSubmitter.remove(file);
                this.queue.write(this.local.toLocal(file), file, application);
                switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(file).getState()) {
                    case local: {
                        Timestamp feature2;
                        NSDictionary dict;
                        if (this.metadata.read(this.local.toLocal(file), MetadataStorage.Key.modificationdate) != null && null != (dict = this.metadata.read(this.local.toLocal(file), MetadataStorage.Key.modificationdate)) && null != (feature2 = (Timestamp)this.pool.getFeature(Timestamp.class))) {
                            this.queue.timestamp(this.local.toLocal(file), file, Long.valueOf(Long.parseLong(dict.get((Object)"Timestamp").toString())));
                        }
                        if (this.metadata.read(this.local.toLocal(file), MetadataStorage.Key.permission) == null || null == (dict = this.metadata.read(this.local.toLocal(file), MetadataStorage.Key.permission)) || null == (feature2 = (UnixPermission)this.pool.getFeature(UnixPermission.class))) break;
                        this.queue.chmod(this.local.toLocal(file), file, new PermissionDictionary().deserialize((Object)dict));
                    }
                }
                break;
            }
            default: {
                log.warn(String.format("Skip write on close for file %s with missing write in progress flag", file));
            }
        }
        if (lockId != null && releaseLock) {
            this.queue.unlock(this.local.toLocal(file), file, lockId);
        }
        return this.local.close(file, flags, application);
    }

    private void copyBufferToLocalCache(Path file, MarkerBuffer buffer) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Sync buffer %s for file %s", buffer, file));
        }
        TransferStatus status = new TransferStatus().withLength(buffer.length().longValue());
        InputStream in = buffer.getInputStream();
        new StreamCopier((StreamCancelation)status, (StreamProgress)status).transfer(in, this.local.toLocal(file).getOutputStream(false));
        if (status.isComplete()) {
            buffer.close();
        }
        this.local.setattr(file, file.getType(), file.attributes());
        this.metadata.delete(this.local.toLocal(file), MetadataStorage.Key.placeholder);
        DescriptiveUrl url = ((UrlProvider)this.pool.getFeature(UrlProvider.class)).toUrl(file).find(DescriptiveUrl.Type.provider);
        if (this.preferences.getBoolean("queue.download.quarantine")) {
            this.quarantineService.setQuarantine(this.local.toLocal(file), new HostUrlProvider().withUsername(false).get(this.bookmark), url.getUrl());
        }
        if (this.preferences.getBoolean("queue.download.wherefrom")) {
            this.quarantineService.setWhereFrom(this.local.toLocal(file), url.getUrl());
        }
        this.fileStatusChanged(Collections.singleton(file), Operation.read, new FileStatusService.Status(FileStatusService.SyncState.synced));
    }

    public Inode touch(Path file) throws BackgroundException {
        switch (this.createSwitch.getStatus(file).getState()) {
            case remote: {
                return (Inode)this.proxy.touch(file);
            }
        }
        Path directory = file.getParent();
        switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(directory).getState()) {
            case unknown: {
                try {
                    FilesystemIncrementalListProgressListener l = new FilesystemIncrementalListProgressListener(this.bookmark, (ProgressListener)this.controller);
                    this.list(directory, (FilesystemListProgressListener)l);
                    l.await();
                    break;
                }
                catch (ConnectionCanceledException l) {
                    break;
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Failure listing directory %s. Return index from local cache. %s", new Object[]{directory, e}));
                    this.error(new SerializableOperation(Operation.list, this.local.toLocal(directory), directory), e);
                }
            }
        }
        Object result = this.local.touch(file);
        this.generations.increment(directory);
        if (this.preferences.getBoolean("fs.sync.touch.enqueue")) {
            Local l = this.local.toLocal(file);
            if (!FilesystemFilenameBlacklist.temporary.contains(file)) {
                this.queue.write(l, file, Application.notfound);
            }
        }
        if (FilesystemFilenameBlacklist.lockowner.contains(file)) {
            this.owners.add(new FilesystemCacheReference(file));
        }
        return (Inode)result;
    }

    public Object lock(Path file) throws BackgroundException {
        switch (this.createSwitch.getStatus(file).getState()) {
            case remote: {
                return this.proxy.lock(file);
            }
        }
        if (this.getattr(file).getLockId() != null) {
            log.warn(String.format("Found lock in attributes for file %s", file));
            if (null == this.getLock(file)) {
                log.warn(String.format("No lock in metadata for file %s", file));
                throw new LockedException(String.format("File %s is already locked by third party", file.getName()));
            }
        }
        switch (this.reachability.getStatus(file).getState()) {
            case local: {
                log.warn(String.format("Skip obtaining lock for file %s with offline reachability", file));
                return null;
            }
        }
        String existingLockId = this.getLock(file);
        if (existingLockId != null) {
            log.warn(String.format("File %s is already locked with id %s", file, existingLockId));
            return existingLockId;
        }
        switch (new WriteInProgressStatusService(this.local, this.metadata).getStatus(file).getState()) {
            case inprogress: {
                this.queue.lock(this.local.toLocal(file), file);
                break;
            }
            default: {
                try {
                    String lockId = (String)this.pool.await((Worker)new FilesystemLockWorker(LockPatternService.standard, this.owners, file));
                    if (lockId != null) {
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Locked file %s with id %s", file, lockId));
                        }
                        NSDictionary dict = new NSDictionary();
                        dict.put(MetadataStorage.Key.lockid.name(), (Object)lockId);
                        this.metadata.write(this.local.toLocal(file), MetadataStorage.Key.lockid, dict);
                        return lockId;
                    }
                    break;
                }
                catch (LockedException e) {
                    log.warn(String.format("File %s is locked on server", file));
                    throw e;
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Ignore failure %s trying to obtain lock for %s", new Object[]{e, file}));
                }
            }
        }
        return null;
    }

    public void unlock(Path file) throws BackgroundException {
        switch (this.createSwitch.getStatus(file).getState()) {
            case remote: {
                this.proxy.unlock(file);
                break;
            }
            default: {
                String lockId = this.getLock(file);
                if (lockId == null) {
                    log.warn(String.format("No lock for %s found in metadata. Skip unlocking.", file));
                    break;
                }
                this.queue.unlock(this.local.toLocal(file), file, lockId);
            }
        }
    }

    public String getLock(Path file) {
        switch (this.writeSwitch.getStatus(file).getState()) {
            case remote: {
                return this.proxy.getLock(file);
            }
        }
        return this.local.getLock(file);
    }

    public void truncate(Path file, long size) throws BackgroundException {
        switch (this.createSwitch.getStatus(file).getState()) {
            case remote: {
                this.proxy.truncate(file, size);
                break;
            }
            default: {
                this.local.truncate(file, size);
                this.metadata.delete(this.local.toLocal(file), MetadataStorage.Key.placeholder);
                this.generations.increment(file.getParent());
            }
        }
    }

    public Inode mkdir(Path directory) throws BackgroundException {
        switch (this.createSwitch.getStatus(directory).getState()) {
            case remote: {
                return (Inode)this.proxy.mkdir(directory);
            }
        }
        switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(directory.getParent()).getState()) {
            case unknown: {
                try {
                    FilesystemIncrementalListProgressListener l = new FilesystemIncrementalListProgressListener(this.bookmark, (ProgressListener)this.controller);
                    this.list(directory.getParent(), (FilesystemListProgressListener)l);
                    l.await();
                    break;
                }
                catch (ConnectionCanceledException l) {
                    break;
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Failure listing directory %s. Return index from local cache. %s", new Object[]{directory, e}));
                    this.error(new SerializableOperation(Operation.list, this.local.toLocal(directory.getParent()), directory.getParent()), e);
                }
            }
        }
        Object result = this.local.mkdir(directory);
        this.generations.increment(directory.getParent());
        if (this.preferences.getBoolean("fs.sync.mkdir.enqueue") && !FilesystemFilenameBlacklist.temporary.contains(directory)) {
            RegionService prompt;
            Location.Name name;
            Location location;
            if (((PathContainerService)this.getFeature(PathContainerService.class)).isContainer(directory) && (location = (Location)this.getFeature(Location.class)) != null && !location.getLocations().isEmpty() && (name = (prompt = RegionServiceFactory.get()).select(location.getLocations(), location.getDefault())) != null) {
                directory.attributes().setRegion(name.getIdentifier());
            }
            this.queue.mkdir(this.local.toLocal(directory), directory);
        }
        return (Inode)result;
    }

    public Inode symlink(Path file, Path target) throws BackgroundException {
        switch (this.createSwitch.getStatus(file).getState()) {
            case remote: {
                return (Inode)this.proxy.symlink(file, target);
            }
        }
        Object result = this.local.symlink(file, target);
        this.generations.increment(file.getParent());
        if (!FilesystemFilenameBlacklist.temporary.contains(file)) {
            this.queue.symlink(this.local.toLocal(file), this.local.toLocal(target), file, target);
        }
        return (Inode)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Path, Path> rename(Path file, Path target) throws BackgroundException {
        switch (this.writeSwitch.getStatus(file).getState()) {
            case remote: {
                return this.proxy.rename(file, target);
            }
        }
        this.blockingCacheLock.acquire(file, QueueLock.Option.branch);
        try {
            NSDictionary dict = new NSDictionary();
            dict.put("Path", (NSObject)target.serialize(SerializerFactory.get()));
            dict.put("Local", (NSObject)this.local.toLocal(target).serialize(SerializerFactory.get()));
            this.metadata.write(this.local.toLocal(file), MetadataStorage.Key.rename, dict);
            FileStatusService.Status status = new PlaceholderStatusService(this.local, this.metadata).getStatus(file);
            this.local.rename(file, target);
            switch (status.getState()) {
                case local: 
                case ignored: {
                    if (!FilesystemFilenameBlacklist.temporary.contains(target)) {
                        RegionService prompt;
                        Location.Name name;
                        Location location;
                        this.metadata.delete(this.local.toLocal(file), MetadataStorage.Key.rename);
                        this.metadata.delete(this.local.toLocal(target), MetadataStorage.Key.rename);
                        if (file.isFile()) {
                            log.warn(String.format("Upload file %s to remote previously only in local cache as %s", target, file));
                            this.queue.write(this.local.toLocal(target), target, Application.notfound);
                            break;
                        }
                        if (new SyncQueueStatusService(this.queue, this.local, this.metadata).getStatus(file).getState() == FileStatusService.SyncState.inprogress) {
                            this.queue.rename(this.local.toLocal(file), this.local.toLocal(target), file, target);
                            break;
                        }
                        log.warn(String.format("Create directory %s on remote previously only in local cache as %s", target, file));
                        if (((PathContainerService)this.getFeature(PathContainerService.class)).isContainer(file) && (location = (Location)this.getFeature(Location.class)) != null && !location.getLocations().isEmpty() && (name = (prompt = RegionServiceFactory.get()).select(location.getLocations(), location.getDefault())) != null) {
                            target.attributes().setRegion(name.getIdentifier());
                        }
                        this.metadata.delete(this.local.toLocal(file), MetadataStorage.Key.rename);
                        this.metadata.delete(this.local.toLocal(target), MetadataStorage.Key.rename);
                        this.queue.mkdir(this.local.toLocal(target), target);
                        List<Path> recursive = this.collectChildrenToUpload(target);
                        for (Path p : recursive) {
                            if (p.isDirectory()) {
                                this.queue.mkdir(this.local.toLocal(p), p);
                                continue;
                            }
                            this.queue.write(this.local.toLocal(p), p, Application.notfound);
                        }
                        break;
                    }
                    log.warn(String.format("Skip remote operation for rename of %s to %s", file, target));
                    this.metadata.delete(this.local.toLocal(file), MetadataStorage.Key.rename);
                    this.metadata.delete(this.local.toLocal(target), MetadataStorage.Key.rename);
                    break;
                }
                default: {
                    if (FilesystemFilenameBlacklist.temporaryfilenames.contains(target)) {
                        if (FilesystemFilenameBlacklist.skipmove.contains(file)) {
                            log.warn(String.format("Skip deleting file %s on remote which is renamed to filename %s matching temporary pattern", file, target));
                            this.metadata.delete(this.local.toLocal(target), MetadataStorage.Key.metadata);
                            break;
                        }
                        this.metadata.delete(this.local.toLocal(file), MetadataStorage.Key.rename);
                        this.metadata.delete(this.local.toLocal(target), MetadataStorage.Key.rename);
                        log.warn(String.format("Delete file %s on remote which is renamed to filename %s matching temporary pattern", file, target));
                        this.queue.delete(this.local.toLocal(file), file);
                        break;
                    }
                    this.queue.rename(this.local.toLocal(file), this.local.toLocal(target), file, target);
                }
            }
            this.local.invalidate(file);
            this.generations.increment(file.getParent());
            this.generations.increment(target.getParent());
            if (file.isDirectory()) {
                this.generations.increment(file);
                this.generations.increment(target);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Preserve remote metadata of file %s renamed to %s", file, target));
            }
            Map<Path, Path> map = Collections.singletonMap(file, target);
            return map;
        }
        finally {
            this.blockingCacheLock.release(file);
        }
    }

    private List<Path> collectChildrenToUpload(Path folder) throws BackgroundException {
        Path next;
        ArrayList<Path> children = new ArrayList<Path>();
        if (log.isDebugEnabled()) {
            log.debug(String.format("List children for file %s with local only state in cache", folder));
        }
        FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(new Host((Protocol)new LocalProtocol()));
        this.local.list(folder, (FilesystemListProgressListener)listener, 0L);
        while ((next = listener.next()) != null) {
            if (FilesystemFilenameBlacklist.localonly.contains(next)) {
                log.warn(String.format("Skip local only file %s", next));
                continue;
            }
            children.add(next);
            if (!next.isDirectory()) continue;
            List<Path> recursive = this.collectChildrenToUpload(next);
            log.debug(String.format("Add %d children in folder %s", recursive.size(), next));
            children.addAll(recursive);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Path> delete(Path file) throws BackgroundException {
        Delete feature = (Delete)this.getFeature(Delete.class);
        if (!feature.isSupported(file.withAttributes(this.getattr(file)))) {
            switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(file).getState()) {
                case local: 
                case ignored: {
                    break;
                }
                default: {
                    BackgroundException failure = new UnsupportedException(MessageFormat.format(LocaleFactory.localizedString((String)"Cannot delete {0}", (String)"Error"), file.getName())).withFile(file);
                    log.warn(String.format("Fail fast with failure %s", new Object[]{failure}));
                    this.alert.alert(this.proxy.getHost(), failure, new StringBuilder());
                    throw failure;
                }
            }
        }
        switch (this.writeSwitch.getStatus(file).getState()) {
            case remote: {
                return this.proxy.delete(file);
            }
        }
        this.blockingCacheLock.acquire(file, QueueLock.Option.branch);
        try {
            FileStatusService.Status status = new PlaceholderStatusService(this.local, this.metadata).getStatus(file);
            Local l = this.local.toLocal(file);
            this.metadata.write(l, MetadataStorage.Key.delete, new NSDictionary());
            try {
                this.local.delete(file);
            }
            catch (NotfoundException e) {
                log.warn(String.format("Failure deleting %s in cache", file));
            }
            block8 : switch (status.getState()) {
                case local: 
                case ignored: {
                    switch (new SyncQueueStatusService(this.queue, this.local, this.metadata).getStatus(file).getState()) {
                        case inprogress: {
                            this.queue.delete(l, file);
                            break block8;
                        }
                    }
                    log.debug(String.format("Skip deleting local only file %s", file));
                    this.metadata.delete(l, MetadataStorage.Key.delete);
                    break;
                }
                default: {
                    this.queue.delete(l, file);
                }
            }
            if (FilesystemFilenameBlacklist.lockowner.contains(file)) {
                Path next;
                this.owners.remove(new FilesystemCacheReference(file));
                Pattern pattern = LockPatternService.standard.match(file);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Find locked files in %s matching %s", file.getParent(), pattern));
                }
                FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(new Host((Protocol)new LocalProtocol()));
                this.local.list(file.getParent(), (FilesystemListProgressListener)listener, 0L);
                while ((next = listener.next()) != null) {
                    if (!pattern.matcher(next.getName()).matches()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Unlock matching file %s", next));
                    }
                    this.unlock(next);
                }
            }
            this.local.invalidate(file);
            this.generations.increment(file.getParent());
            Set<Path> set = Collections.singleton(file);
            return set;
        }
        finally {
            this.blockingCacheLock.release(file);
        }
    }

    public Worker<AttributedList<Path>> list(Path directory, FilesystemListProgressListener l, long fromCookie) throws BackgroundException {
        switch (this.listSwitch.getStatus(directory).getState()) {
            case remote: 
            case placeholder: {
                try {
                    Worker<AttributedList<Path>> worker = this.list(directory, l);
                    log.warn(String.format("Waiting for result of %s", worker));
                    l.await();
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Listing completed for %s", worker));
                    }
                    return worker;
                }
                catch (NotfoundException e) {
                    log.warn(String.format("Failure %s listing directory %s", new Object[]{directory, e}));
                    switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(directory).getState()) {
                        case local: 
                        case ignored: {
                            log.warn(String.format("Ignore failure %s for directory %s with local only state", new Object[]{e, directory}));
                            break;
                        }
                        default: {
                            log.warn(String.format("Throw failure %s for directory %s with placeholder status", new Object[]{e, directory}));
                            throw e;
                        }
                    }
                }
                catch (ConnectionCanceledException e) {
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Failure listing directory %s. Return index from local cache. %s", new Object[]{directory, e}));
                    this.error(new SerializableOperation(Operation.list, this.local.toLocal(directory), directory), e);
                    l.error(null);
                }
                return this.local.list(directory, l, fromCookie);
            }
        }
        if (0L == fromCookie && this.preferences.getBoolean("fs.sync.list.index.update")) {
            new DefaultIndexerIndexCallback(this.bookmark, this.local, this.metadata, this.directoryIndexer, this.reachability, this.badgeStatusService, this.reload).index(this.local.toLocal(directory), directory);
        }
        return this.local.list(directory, l, fromCookie);
    }

    protected Worker<AttributedList<Path>> list(Path directory, FilesystemListProgressListener listener) throws BackgroundException {
        switch (this.reachability.getStatus(directory).getState()) {
            case local: {
                log.warn(String.format("Skip fetching directory listing for %s with offline reachability status", directory));
                throw new ConnectionCanceledException();
            }
        }
        switch (this.directoryIndexer.getStatus()) {
            case stopped: 
            case paused: {
                log.warn(String.format("Skip fetching directory listing for %s with indexer paused", directory));
                throw new ConnectionCanceledException();
            }
        }
        SyncListProgressListener sync = new SyncListProgressListener(this.bookmark, directory, this.local, this.blockingCacheLock, this.options, this.metadata, this.history, listener, (ReloadService)new DisabledReloadService(), new DefaultQueueReadCallback(this.queue, this.local, this.metadata), new DefaultIndexerIndexCallback(this.bookmark, this.local, this.metadata, this.directoryIndexer, this.reachability, this.badgeStatusService, (ReloadService)new DisabledReloadService()), new DefaultSetattrCallback(this.bookmark, this.local, this.metadata, this.history), this.delete, this.placeholder);
        return this.proxy.list(directory, (FilesystemListProgressListener)sync, 0L);
    }

    public Path find(Path directory, String filename, FilesystemCallbacks.Flags flags) throws BackgroundException {
        if (new FilenameMatchPathPredicate(this.composer.compose(directory, filename, EnumSet.of(AbstractPath.Type.directory)), this.bookmark.getProtocol().getCaseSensitivity()).test(this.workdir)) {
            return this.workdir;
        }
        switch (this.readSwitch.getStatus(directory).getState()) {
            case remote: 
            case placeholder: {
                switch (flags) {
                    case online: {
                        if (FilesystemFilenameBlacklist.blacklist.contains(PathNormalizer.name((String)filename)) || FilesystemFilenameBlacklist.blacklist.contains(directory)) break;
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Attempt to find %s on server in placeholder directory %s", filename, directory));
                        }
                        try {
                            FilesystemIncrementalListProgressListener l = new FilesystemIncrementalListProgressListener(this.bookmark);
                            this.list(directory, (FilesystemListProgressListener)l);
                            l.await();
                            break;
                        }
                        catch (ConnectionCanceledException l) {
                            break;
                        }
                        catch (BackgroundException e) {
                            log.warn(String.format("Failure listing directory %s. Return index from local cache. %s", new Object[]{directory, e}));
                            this.error(new SerializableOperation(Operation.list, this.local.toLocal(directory), directory), e);
                        }
                    }
                }
                return this.local.find(directory, filename, flags);
            }
        }
        if (FilesystemFilenameBlacklist.delayedindex.contains(filename)) {
            this.delayedIndexerSubmitter.submit(directory, new SerializableOperation(Operation.list, this.local.toLocal(directory), directory));
        }
        return this.local.find(directory, filename, flags);
    }

    public EnumSet<AbstractPath.Type> type(Path file) {
        switch (this.readSwitch.getStatus(file.getParent()).getState()) {
            case remote: {
                return this.proxy.type(file);
            }
        }
        return this.local.type(file);
    }

    public PathAttributes getattr(Path file, boolean cached) throws BackgroundException {
        switch (this.readSwitch.getStatus(file).getState()) {
            case remote: {
                return this.proxy.getattr(file, cached);
            }
        }
        return this.local.getattr(file, cached);
    }

    public boolean setattr(Path file, long timestamp) throws BackgroundException {
        if (this.preferences.getBoolean("fs.sync.timestamp.threshold.enable")) {
            switch (new WriteInProgressStatusService(this.local, this.metadata).getStatus(file).getState()) {
                case inprogress: {
                    break;
                }
                default: {
                    if (timestamp + (long)this.preferences.getInteger("fs.sync.timestamp.threshold.ms") <= System.currentTimeMillis()) break;
                    log.warn(String.format("Skip setting timestamp %d for file %s", timestamp, file));
                    return false;
                }
            }
        }
        switch (this.writeSwitch.getStatus(file).getState()) {
            case remote: {
                return this.proxy.setattr(file, timestamp);
            }
        }
        if (!this.local.setattr(file, timestamp)) {
            return false;
        }
        this.generations.increment(file.getParent());
        switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(file).getState()) {
            case local: 
            case ignored: {
                switch (new SyncQueueStatusService(this.queue, this.local, this.metadata).getStatus(file).getState()) {
                    case unknown: {
                        log.warn(String.format("Skip queueing timestamp operation for %s with no pending write operation", file));
                        return true;
                    }
                }
            }
        }
        if (this.preferences.getBoolean("fs.sync.timestamp.enqueue")) {
            if (((Write)this.pool.getFeature(Write.class)).timestamp()) {
                log.warn(String.format("Skip queuing timestamp operation for %s with modification date support in write", file));
            } else {
                Timestamp feature = (Timestamp)this.pool.getFeature(Timestamp.class);
                if (null != feature) {
                    this.queue.timestamp(this.local.toLocal(file), file, Long.valueOf(timestamp));
                }
            }
        }
        return true;
    }

    public boolean setattr(Path file, Permission permission) throws BackgroundException {
        switch (this.writeSwitch.getStatus(file).getState()) {
            case remote: {
                return this.proxy.setattr(file, permission);
            }
        }
        if (!this.local.setattr(file, permission)) {
            return false;
        }
        this.generations.increment(file.getParent());
        switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(file).getState()) {
            case local: 
            case ignored: {
                break;
            }
            default: {
                UnixPermission feature;
                if (!this.preferences.getBoolean("fs.sync.chmod.enqueue") || null == (feature = (UnixPermission)this.pool.getFeature(UnixPermission.class))) break;
                this.queue.chmod(this.local.toLocal(file), file, permission);
            }
        }
        return true;
    }

    public int read(Path file, byte[] chunk, long offset, int count) throws BackgroundException {
        switch (this.readSwitch.getStatus(file).getState()) {
            case remote: 
            case placeholder: {
                try {
                    return this.proxy.read(file, chunk, offset, count);
                }
                catch (NotfoundException e) {
                    switch (this.readSwitch.getStatus(file).getState()) {
                        case placeholder: {
                            log.warn(String.format("Delete file %s in cache no longer found on server", file));
                            this.delete.delete(this.local.toLocal(file), file);
                            this.invalidate(file.getParent());
                            break;
                        }
                        default: {
                            this.error(new SerializableOperation(Operation.read, this.local.toLocal(file), file), (BackgroundException)((Object)e));
                        }
                    }
                    throw e;
                }
                catch (BackgroundException e) {
                    this.error(new SerializableOperation(Operation.read, this.local.toLocal(file), file), e);
                    switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(file).getState()) {
                        case unknown: 
                        case placeholder: {
                            log.warn(String.format("Cannot read from file %s with placeholder only in cache", file));
                            this.alert.alert(this.bookmark, e, new StringBuilder());
                            throw e;
                        }
                    }
                }
            }
        }
        switch (new PlaceholderStatusService(this.local, this.metadata).getStatus(file).getState()) {
            case unknown: 
            case placeholder: {
                log.warn(String.format("Deny read from file %s with placeholder only in cache", file));
                BackgroundException failure = new AccessDeniedException(MessageFormat.format(LocaleFactory.localizedString((String)"Download {0} failed", (String)"Error"), file.getName())).withFile(file);
                this.alert.alert(this.bookmark, failure, new StringBuilder());
                throw failure;
            }
        }
        return this.local.read(file, chunk, offset, count);
    }

    public int write(Path file, byte[] chunk, int count, long offset) throws BackgroundException {
        switch (this.writeSwitch.getStatus(file).getState()) {
            case remote: {
                return this.proxy.write(file, chunk, count, offset);
            }
            case placeholder: {
                log.warn(String.format("Write to file %s with placeholder only in cache", file));
                MarkerBuffer buffer = this.proxy.buffer(file);
                if (!buffer.isComplete()) {
                    log.warn(String.format("Deny write to file %s with placeholder only in cache", file));
                    BackgroundException failure = new AccessDeniedException(MessageFormat.format(LocaleFactory.localizedString((String)"Download {0} failed", (String)"Error"), file.getName())).withFile(file);
                    this.alert.alert(this.bookmark, failure, new StringBuilder());
                    throw failure;
                }
                this.copyBufferToLocalCache(file, buffer);
                this.metadata.delete(this.local.toLocal(file), MetadataStorage.Key.placeholder);
            }
        }
        this.metadata.write(this.local.toLocal(file), MetadataStorage.Key.write, new NSDictionary());
        if (this.preferences.getBoolean("fs.sync.queue.submit.delay.enable") && !FilesystemFilenameBlacklist.temporary.contains(file)) {
            switch (new SyncQueueStatusService(this.queue, this.local, this.metadata).getStatus(file).getState()) {
                case inprogress: {
                    break;
                }
                default: {
                    this.delayedQueueSubmitter.submit(file, new SerializableOperation(Operation.write, this.local.toLocal(file), file).withLength(this.local.toLocal(file).attributes().getSize()).withApplication(Application.notfound));
                }
            }
        }
        return this.local.write(file, chunk, count, offset);
    }

    public Quota.Space quota(Path workdir) throws BackgroundException {
        switch (this.reachability.getStatus(workdir).getState()) {
            case unknown: {
                try {
                    Quota.Space quota = this.proxy.quota(workdir);
                    NSDictionary dict = new NSDictionary();
                    dict.put("used", (Object)quota.used);
                    dict.put("available", (Object)quota.available);
                    this.metadata.write(this.local.toLocal(workdir), MetadataStorage.Key.quota, dict);
                    return quota;
                }
                catch (BackgroundException e) {
                    switch (this.diagnostics.determine(e)) {
                        case login: 
                        case cancel: {
                            throw e;
                        }
                    }
                    log.warn(String.format("Ignore failure setting current quota for %s. %s", workdir, e.getMessage()));
                }
            }
        }
        return this.local.quota(workdir);
    }

    private void error(SerializableOperation operation, BackgroundException e) {
        switch (this.diagnostics.determine(e)) {
            case application: 
            case quota: {
                this.metadata.write(operation.getLocal(), MetadataStorage.Key.error, new DefaultExceptionSerializer().serialize(operation, e));
                this.fileStatusChanged(Collections.singleton(operation.getRemote()), operation.getOperation(), new FileStatusService.Status(FileStatusService.SyncState.error, new SerializableOperationException(operation, e)));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SyncFilesystemOperations{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

