/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.ConnectCallback;
import ch.iterate.mountainduck.fs.ConnectMode;
import ch.iterate.mountainduck.fs.DefaultFilesystemSessionPool;
import ch.iterate.mountainduck.fs.FailFastFilesystemOperations;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.FilesystemSessionPool;
import ch.iterate.mountainduck.fs.SessionFilesystemOperations;
import ch.iterate.mountainduck.fs.SyncFilesystemOperations;
import ch.iterate.mountainduck.service.FileBadgeService;
import ch.iterate.mountainduck.service.ReloadService;

public class FilesystemOperationsFactory {
    public static <Inode> FilesystemOperations<Inode> getDefault(Controller controller, Host bookmark, FileidMapper<Inode> fileid, FilesystemDirectoryGenerations generations, FileBadgeService badge, ReloadService reload, ConnectCallback callback) {
        Object operations;
        DefaultFilesystemSessionPool pool = new DefaultFilesystemSessionPool(controller, bookmark, callback);
        SessionFilesystemOperations online = new SessionFilesystemOperations(controller, bookmark, (FilesystemSessionPool)pool, fileid, generations);
        switch (ConnectMode.get((Host)bookmark)) {
            case online: {
                operations = online;
                break;
            }
            default: {
                operations = new SyncFilesystemOperations<Inode>(online, controller, bookmark, (FilesystemSessionPool)pool, fileid, generations, badge, reload);
            }
        }
        if (PreferencesFactory.get().getBoolean("fs.failfast.enable")) {
            return new FailFastFilesystemOperations(operations);
        }
        return operations;
    }
}

