/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.exception.QuotaException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.threading.AlertCallback;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.NotificationServiceAlertCallback;
import ch.iterate.mountainduck.fs.ProxyFilesystemOperations;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FailFastFilesystemOperations<Inode>
extends ProxyFilesystemOperations<Inode> {
    private static final Logger log = LogManager.getLogger((String)FailFastFilesystemOperations.class.getName());
    private final AlertCallback alert = new NotificationServiceAlertCallback();
    private final FilesystemOperations<Inode> proxy;

    public FailFastFilesystemOperations(FilesystemOperations<Inode> proxy) {
        super(proxy);
        this.proxy = proxy;
    }

    public void open(Path file, FilesystemCallbacks.Mode flags, Long allocate, Application application) throws BackgroundException {
        switch (flags) {
            case write: {
                PathAttributes attr = this.getattr(file);
                if (Permission.EMPTY == attr.getPermission() || attr.getPermission().isWritable()) break;
                BackgroundException failure = new LockedException(String.format("Deny opening file %s in write mode with permission %s", file, attr.getPermission())).withFile(file);
                log.warn(String.format("Fail fast with failure %s", new Object[]{failure}));
                this.alert.alert(this.proxy.getHost(), failure, new StringBuilder());
                throw failure;
            }
        }
        super.open(file, flags, allocate, application);
    }

    public Inode touch(Path file) throws BackgroundException {
        Touch feature = (Touch)this.proxy.getPool().getFeature(Touch.class);
        if (!(FilesystemFilenameBlacklist.temporary.contains(file) || feature.isSupported(file.getParent().withAttributes(this.proxy.getattr(file.getParent())), file.getName()) || feature.isSupported(file.getParent().withAttributes(this.proxy.getattr(file.getParent())), StringUtils.lowerCase((String)StringUtils.deleteWhitespace((String)file.getName()))))) {
            BackgroundException failure = new QuotaException(MessageFormat.format(LocaleFactory.localizedString((String)"Cannot create {0}", (String)"Error"), file.getName()), null).withFile(file);
            log.warn(String.format("Fail fast with failure %s", new Object[]{failure}));
            this.alert.alert(this.proxy.getHost(), failure, new StringBuilder());
            throw failure;
        }
        return (Inode)this.proxy.touch(file);
    }

    public void truncate(Path file, long size) throws BackgroundException {
        Touch feature = (Touch)this.proxy.getPool().getFeature(Touch.class);
        if (!FilesystemFilenameBlacklist.temporary.contains(file) && !feature.isSupported(file.getParent().withAttributes(this.proxy.getattr(file.getParent())), file.getName())) {
            BackgroundException failure = new QuotaException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName()), null).withFile(file);
            log.warn(String.format("Fail fast with failure %s", new Object[]{failure}));
            this.alert.alert(this.proxy.getHost(), failure, new StringBuilder());
            throw failure;
        }
        this.proxy.truncate(file, size);
    }

    public Inode mkdir(Path directory) throws BackgroundException {
        Directory feature = (Directory)this.proxy.getPool().getFeature(Directory.class);
        boolean supported = feature.isSupported(directory.getParent().withAttributes(this.proxy.getattr(directory.getParent())), directory.getName());
        if (!supported) {
            BackgroundException failure = new UnsupportedException(MessageFormat.format(LocaleFactory.localizedString((String)"Cannot create folder {0}", (String)"Error"), directory.getName())).withFile(directory);
            if (!feature.isSupported(directory.getParent().withAttributes(this.proxy.getattr(directory.getParent())), StringUtils.lowerCase((String)StringUtils.deleteWhitespace((String)directory.getName())))) {
                log.warn(String.format("Fail fast with failure %s", new Object[]{failure}));
                this.alert.alert(this.proxy.getHost(), failure, new StringBuilder());
                throw failure;
            }
            if (!FilesystemFilenameBlacklist.temporaryfolders.contains(directory)) {
                log.warn(String.format("Fail fast with failure %s", new Object[]{failure}));
                this.alert.alert(this.proxy.getHost(), failure, new StringBuilder());
                throw failure;
            }
        }
        return (Inode)this.proxy.mkdir(directory);
    }

    public Inode symlink(Path file, Path target) throws BackgroundException {
        return (Inode)this.proxy.symlink(file, target);
    }

    public Map<Path, Path> rename(Path file, Path target) throws BackgroundException {
        if (!FilesystemFilenameBlacklist.temporary.contains(target)) {
            boolean supported;
            Move feature;
            if (FilesystemFilenameBlacklist.temporary.contains(file)) {
                if (target.isDirectory()) {
                    feature = (Directory)this.proxy.getPool().getFeature(Directory.class);
                    supported = feature.isSupported(target.getParent().withAttributes(this.proxy.getattr(target.getParent())), target.getName());
                } else {
                    feature = (Touch)this.proxy.getPool().getFeature(Touch.class);
                    supported = feature.isSupported(target.getParent().withAttributes(this.proxy.getattr(target.getParent())), target.getName());
                }
            } else {
                feature = (Move)this.proxy.getPool().getFeature(Move.class);
                supported = feature.isSupported(file.withAttributes(this.proxy.getattr(file)), target);
            }
            if (!supported) {
                BackgroundException failure = new UnsupportedException(MessageFormat.format(LocaleFactory.localizedString((String)"Cannot rename {0}", (String)"Error"), file.getName())).withFile(file);
                log.warn(String.format("Fail fast with failure %s", new Object[]{failure}));
                this.alert.alert(this.proxy.getHost(), failure, new StringBuilder());
                throw failure;
            }
        }
        return this.proxy.rename(file, target);
    }

    public int write(Path file, byte[] chunk, int count, long offset) throws BackgroundException {
        Touch feature = (Touch)this.proxy.getPool().getFeature(Touch.class);
        if (!FilesystemFilenameBlacklist.temporary.contains(file) && !feature.isSupported(file.getParent().withAttributes(this.proxy.getattr(file.getParent())), file.getName())) {
            BackgroundException failure = new AccessDeniedException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName())).withFile(file);
            log.warn(String.format("Fail fast with failure %s", new Object[]{failure}));
            this.alert.alert(this.proxy.getHost(), failure, new StringBuilder());
            throw failure;
        }
        return this.proxy.write(file, chunk, count, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FailFastFilesystemOperations{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

