/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelayedSubmitter<Key, Operation>
implements RemovalListener<Key, DelayedEntry<Operation>> {
    private static final Logger log = LogManager.getLogger((String)DelayedSubmitter.class.getName());
    private final Callback<Operation> callback;
    private final LRUCache<Key, DelayedEntry<Operation>> memory;
    private final ScheduledThreadPool cleanup = new ScheduledThreadPool();

    public DelayedSubmitter(Callback<Operation> callback, final long delay) {
        this.callback = callback;
        this.memory = LRUCache.build((RemovalListener)this, (long)-1L, (long)delay);
        this.cleanup.schedule(new Runnable(){

            @Override
            public void run() {
                DelayedSubmitter.this.memory.evict();
                DelayedSubmitter.this.cleanup.schedule((Runnable)this, Long.valueOf(delay), TimeUnit.MILLISECONDS);
            }
        }, Long.valueOf(delay), TimeUnit.MILLISECONDS);
    }

    public void remove(Key file) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Remove operation for file %s", file));
        }
        this.memory.remove(file);
    }

    public void submit(Key file, Operation operation) {
        this.memory.put(file, new DelayedEntry<Operation>(operation));
    }

    public void close() {
        this.memory.clear();
        this.cleanup.shutdown();
    }

    public void onRemoval(RemovalNotification<Key, DelayedEntry<Operation>> notification) {
        switch (notification.getCause()) {
            case EXPIRED: {
                Object operation = ((DelayedEntry)notification.getValue()).getOperation();
                if (System.currentTimeMillis() > ((DelayedEntry)notification.getValue()).getTimestamp() + this.getDelay(operation)) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Submit operation %s after delay", operation));
                    }
                    this.callback.submit(operation);
                    break;
                }
                this.memory.put(notification.getKey(), (Object)((DelayedEntry)notification.getValue()));
            }
        }
    }

    public long getDelay(Operation operation) {
        return 0L;
    }

    public static interface Callback<Operation> {
        public void submit(Operation var1);
    }

    protected static class DelayedEntry<Operation> {
        private final long timestamp = System.currentTimeMillis();
        private final Operation operation;

        public DelayedEntry(Operation operation) {
            this.operation = operation;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelayedEntry that = (DelayedEntry)o;
            return this.operation.equals(that.operation);
        }

        public int hashCode() {
            return Objects.hash(this.operation);
        }
    }
}

