/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.DelayedSubmitter;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelayedQueueSubmitter
extends DelayedSubmitter<Path, SerializableOperation> {
    private static final Logger log = LogManager.getLogger((String)DelayedQueueSubmitter.class.getName());
    private final long minDelay;
    private final long maxDelay;

    public DelayedQueueSubmitter(FilesystemOperations<?> fs, SyncQueue queue) {
        this(fs, queue, PreferencesFactory.get().getLong("fs.sync.queue.submit.delay.ms.min"), PreferencesFactory.get().getLong("fs.sync.queue.submit.delay.ms.max"));
    }

    public DelayedQueueSubmitter(FilesystemOperations<?> fs, final SyncQueue queue, long minDelay, long maxDelay) {
        super(new DelayedSubmitter.Callback<SerializableOperation>(){

            @Override
            public void submit(SerializableOperation operation) {
                switch (operation.getOperation()) {
                    case write: {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Submit operation %s", operation));
                        }
                        try {
                            queue.write(operation.getLocal(), operation.getRemote(), operation.getApplication());
                        }
                        catch (BackgroundException backgroundException) {}
                        break;
                    }
                    default: {
                        log.warn(String.format("Operation type %s not supported", operation.getOperation()));
                    }
                }
            }
        }, minDelay);
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
    }

    @Override
    public long getDelay(SerializableOperation operation) {
        return operation.getLength() > 0L ? Math.min(this.maxDelay, Math.max(this.minDelay, 1000L * operation.getLength() / 0x100000L)) : 0L;
    }
}

