/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.DelayedSubmitter;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.sync.queue.DefaultIndexerIndexCallback;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelayedIndexerSubmitter
extends DelayedSubmitter<Path, SerializableOperation> {
    private static final Logger log = LogManager.getLogger((String)DelayedIndexerSubmitter.class.getName());

    public DelayedIndexerSubmitter(FilesystemOperations<?> fs, DefaultIndexerIndexCallback indexer) {
        this(fs, indexer, PreferencesFactory.get().getLong("fs.sync.indexer.submit.delay.ms"));
    }

    public DelayedIndexerSubmitter(FilesystemOperations<?> fs, final DefaultIndexerIndexCallback indexer, long delay) {
        super(new DelayedSubmitter.Callback<SerializableOperation>(){

            @Override
            public void submit(SerializableOperation operation) {
                switch (operation.getOperation()) {
                    case list: {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Submit operation %s", operation));
                        }
                        indexer.index(operation.getLocal(), operation.getRemote());
                        break;
                    }
                    default: {
                        log.warn(String.format("Operation type %s not supported", operation.getOperation()));
                    }
                }
            }
        }, delay);
    }
}

